/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class PossibleMemoryBloat
extends BytecodeScanningDetector {
    private static final Set<String> bloatableSigs = new HashSet<String>();
    private static final Set<String> nonBloatableSigs = new HashSet<String>();
    private static final Set<String> decreasingMethods;
    private static final Set<String> increasingMethods;
    private final BugReporter bugReporter;
    private Map<XField, FieldAnnotation> bloatableCandidates;
    private Map<XField, FieldAnnotation> bloatableFields;
    private OpcodeStack stack;
    private String methodName;
    private Set<FieldAnnotation> threadLocalNonStaticFields;

    public PossibleMemoryBloat(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.bloatableCandidates = new HashMap<XField, FieldAnnotation>();
            this.bloatableFields = new HashMap<XField, FieldAnnotation>();
            this.threadLocalNonStaticFields = new HashSet<FieldAnnotation>();
            this.parseFields(classContext);
            if (this.bloatableCandidates.size() > 0) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
                this.reportMemoryBloatBugs();
                this.reportThreadLocalBugs();
            }
        }
        finally {
            this.stack = null;
            this.bloatableCandidates = null;
            this.bloatableFields = null;
            this.threadLocalNonStaticFields = null;
        }
    }

    private void reportThreadLocalBugs() {
        for (FieldAnnotation fieldAn : this.threadLocalNonStaticFields) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PMB_INSTANCE_BASED_THREAD_LOCAL.name(), 2).addClass((PreorderVisitor)this).addField(fieldAn));
        }
    }

    private void reportMemoryBloatBugs() {
        for (Map.Entry<XField, FieldAnnotation> entry : this.bloatableFields.entrySet()) {
            FieldAnnotation fieldAn = entry.getValue();
            if (fieldAn == null) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PMB_POSSIBLE_MEMORY_BLOAT.name(), 2).addClass((PreorderVisitor)this).addField(fieldAn));
        }
    }

    private void parseFields(ClassContext classContext) {
        Field[] fields;
        JavaClass cls = classContext.getJavaClass();
        for (Field f : fields = cls.getFields()) {
            String sig = f.getSignature();
            if (f.isStatic()) {
                if (!bloatableSigs.contains(sig)) continue;
                this.bloatableCandidates.put(XFactory.createXField((String)cls.getClassName(), (String)f.getName(), (String)f.getSignature(), (boolean)f.isStatic()), FieldAnnotation.fromBCELField((JavaClass)cls, (Field)f));
                continue;
            }
            if (!"Ljava/lang/ThreadLocal;".equals(sig)) continue;
            this.threadLocalNonStaticFields.add(FieldAnnotation.fromBCELField((JavaClass)cls, (Field)f));
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            return;
        }
        if (this.bloatableCandidates.size() > 0) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            if (this.bloatableCandidates.isEmpty()) {
                return;
            }
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 || seen == 185) {
                OpcodeStack.Item itm;
                XField field;
                String sig = this.getSigConstantOperand();
                int argCount = Type.getArgumentTypes((String)sig).length;
                if (this.stack.getStackDepth() > argCount && (field = (itm = this.stack.getStackItem(argCount)).getXField()) != null && this.bloatableCandidates.containsKey(field)) {
                    this.checkMethodAsDecreasingOrIncreasing(field);
                }
            } else if (seen == 179) {
                OpcodeStack.Item item;
                if (this.stack.getStackDepth() > 0 && nonBloatableSigs.contains((item = this.stack.getStackItem(0)).getSignature())) {
                    XField field = item.getXField();
                    this.bloatableFields.remove(field);
                }
            } else if (seen == 176) {
                this.removeFieldsThatGetReturned();
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    protected void removeFieldsThatGetReturned() {
        OpcodeStack.Item returnItem;
        XField field;
        if (this.stack.getStackDepth() > 0 && (field = (returnItem = this.stack.getStackItem(0)).getXField()) != null) {
            this.bloatableCandidates.remove(field);
            this.bloatableFields.remove(field);
        }
    }

    protected void checkMethodAsDecreasingOrIncreasing(XField field) {
        String mName = this.getNameConstantOperand();
        if (decreasingMethods.contains(mName)) {
            this.bloatableCandidates.remove(field);
            this.bloatableFields.remove(field);
        } else if (increasingMethods.contains(mName) && this.bloatableCandidates.containsKey(field)) {
            this.bloatableFields.put(field, this.bloatableCandidates.get(field));
        }
    }

    static {
        bloatableSigs.add("Ljava/util/concurrent/ArrayBlockingQueue;");
        bloatableSigs.add("Ljava/util/ArrayList;");
        bloatableSigs.add("Ljava/util/concurrent/BlockingQueue;");
        bloatableSigs.add("Ljava/util/Collection;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentHashMap;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentSkipListMap;");
        bloatableSigs.add("Ljava/util/concurrent/ConcurrentSkipListSet;");
        bloatableSigs.add("Ljava/util/concurrent/CopyOnWriteArraySet;");
        bloatableSigs.add("Ljava/util/EnumSet;");
        bloatableSigs.add("Ljava/util/EnumMap;");
        bloatableSigs.add("Ljava/util/HashMap;");
        bloatableSigs.add("Ljava/util/HashSet;");
        bloatableSigs.add("Ljava/util/Hashtable;");
        bloatableSigs.add("Ljava/util/IdentityHashMap;");
        bloatableSigs.add("Ljava/util/concurrent/LinkedBlockingQueue;");
        bloatableSigs.add("Ljava/util/LinkedHashMap;");
        bloatableSigs.add("Ljava/util/LinkedHashSet;");
        bloatableSigs.add("Ljava/util/LinkedList;");
        bloatableSigs.add("Ljava/util/List;");
        bloatableSigs.add("Ljava/util/concurrent/PriorityBlockingQueue;");
        bloatableSigs.add("Ljava/util/PriorityQueue;");
        bloatableSigs.add("Ljava/util/Map;");
        bloatableSigs.add("Ljava/util/Queue;");
        bloatableSigs.add("Ljava/util/Set;");
        bloatableSigs.add("Ljava/util/SortedSet;");
        bloatableSigs.add("Ljava/util/SortedMap;");
        bloatableSigs.add("Ljava/util/Stack;");
        bloatableSigs.add("Ljava/lang/StringBuffer;");
        bloatableSigs.add("Ljava/lang/StringBuilder;");
        bloatableSigs.add("Ljava/util/TreeMap;");
        bloatableSigs.add("Ljava/util/TreeSet;");
        bloatableSigs.add("Ljava/util/Vector;");
        nonBloatableSigs.add("Ljava/util/WeakHashMap;");
        decreasingMethods = new HashSet<String>();
        decreasingMethods.add("clear");
        decreasingMethods.add("delete");
        decreasingMethods.add("deleteCharAt");
        decreasingMethods.add("drainTo");
        decreasingMethods.add("poll");
        decreasingMethods.add("pollFirst");
        decreasingMethods.add("pollLast");
        decreasingMethods.add("pop");
        decreasingMethods.add("remove");
        decreasingMethods.add("removeAll");
        decreasingMethods.add("removeAllElements");
        decreasingMethods.add("removeElementAt");
        decreasingMethods.add("removeRange");
        decreasingMethods.add("setLength");
        decreasingMethods.add("take");
        increasingMethods = new HashSet<String>();
        increasingMethods.add("add");
        increasingMethods.add("addAll");
        increasingMethods.add("addElement");
        increasingMethods.add("addFirst");
        increasingMethods.add("addLast");
        increasingMethods.add("append");
        increasingMethods.add("insertElementAt");
        increasingMethods.add("offer");
        increasingMethods.add("put");
    }
}

