/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class PossiblyRedundantMethodCalls
extends BytecodeScanningDetector {
    public static final String PRMC_RISKY_FIELD_USER_KEY = "fbcontrib.PRMC.riskynames";
    public static final String PRMC_RISKY_CLASS_USER_KEY = "fbcontrib.PRMC.riskyclasses";
    public static final String PRMC_HIGH_BYTECOUNT = "fbcontrib.PRMC.highbytecount";
    public static final String PRMC_HIGH_METHODCALLS = "fbcontrib.PRMC.highmethodcalls";
    public static final String PRMC_NORMAL_BYTECOUNT = "fbcontrib.PRMC.normalbytecount";
    public static final String PRMC_NORMAL_METHODCALLS = "fbcontrib.PRMC.normalmethodcalls";
    private static Set<String> riskyMethodNameContents;
    private static int highByteCountLimit;
    private static int highMethodCallLimit;
    private static int normalByteCountLimit;
    private static int normalMethodCallLimit;
    private static Set<String> riskyClassNames;
    private final BugReporter bugReporter;
    private OpcodeStack stack = null;
    private Map<Integer, MethodCall> localMethodCalls = null;
    private Map<String, MethodCall> fieldMethodCalls = null;
    private Map<String, MethodCall> staticMethodCalls = null;
    private BitSet branchTargets = null;

    public PossiblyRedundantMethodCalls(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.localMethodCalls = new HashMap<Integer, MethodCall>();
            this.fieldMethodCalls = new HashMap<String, MethodCall>();
            this.staticMethodCalls = new HashMap<String, MethodCall>();
            this.branchTargets = new BitSet();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.localMethodCalls = null;
            this.fieldMethodCalls = null;
            this.staticMethodCalls = null;
            this.branchTargets = null;
        }
    }

    public void visitCode(Code obj) {
        CodeException[] codeExceptions;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localMethodCalls.clear();
        this.fieldMethodCalls.clear();
        this.staticMethodCalls.clear();
        this.branchTargets.clear();
        for (CodeException codeEx : codeExceptions = obj.getExceptionTable()) {
            this.branchTargets.set(codeEx.getHandlerPC());
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        block41: {
            block44: {
                block43: {
                    block42: {
                        userValue = null;
                        this.stack.precomputation((DismantleBytecode)this);
                        pc = this.getPC();
                        if (this.branchTargets.get(pc)) {
                            this.localMethodCalls.clear();
                            this.fieldMethodCalls.clear();
                            this.branchTargets.clear(pc);
                        }
                        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
                            this.branchTargets.set(this.getBranchTarget());
                            break block41;
                        }
                        if (seen == 170 || seen == 171) {
                            for (int offset : offsets = this.getSwitchOffsets()) {
                                this.branchTargets.set(offset + pc);
                            }
                            break block41;
                        }
                        if (seen == 58 || seen >= 75 && seen <= 78) {
                            this.localMethodCalls.remove(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen));
                            break block41;
                        }
                        if (seen == 181) {
                            fieldSource = "";
                            if (this.stack.getStackDepth() > 0 && (fieldSource = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) {
                                fieldSource = "";
                            }
                            this.fieldMethodCalls.remove(fieldSource + ":" + this.getNameConstantOperand());
                            break block41;
                        }
                        if (seen == 180) {
                            if (this.stack.getStackDepth() > 0 && (userValue = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) {
                                reg = item.getRegisterNumber();
                                if (reg >= 0) {
                                    userValue = String.valueOf(reg);
                                } else {
                                    xf = item.getXField();
                                    if (xf != null) {
                                        userValue = xf.getName();
                                    }
                                }
                            }
                            break block41;
                        }
                        if (seen != 182 && seen != 185 && seen != 184) break block41;
                        signature = this.getSigConstantOperand();
                        parmCount = Type.getArgumentTypes((String)signature).length;
                        neededStackSize = parmCount - (seen == 184 ? 0 : 1);
                        if (this.stack.getStackDepth() <= neededStackSize) break block41;
                        parmConstants = new Object[parmCount];
                        i = 0;
lbl45:
                        // 2 sources

                        while (i < parmCount) {
                            parm = this.stack.getStackItem(i);
                            if (parm.getSignature().charAt(0) != '[' || Values.ZERO.equals(parm.getConstant())) break block42;
                        }
                        ** GOTO lbl69
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        if (userValue != null && this.stack.getStackDepth() > 0) {
                            item = this.stack.getStackItem(0);
                            item.setUserValue((Object)userValue);
                        }
                        return;
                    }
                    parmConstants[i] = parm.getConstant();
                    if (parmConstants[i] != null) break block43;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        item.setUserValue((Object)userValue);
                    }
                    return;
                }
                ++i;
                ** GOTO lbl45
lbl69:
                // 1 sources

                className = this.getClassConstantOperand();
                reg = -1;
                field = null;
                if (seen == 184) {
                    mc = this.staticMethodCalls.get(className);
                }
                obj = this.stack.getStackItem(parmCount);
                reg = obj.getRegisterNumber();
                field = obj.getXField();
                if (reg >= 0) {
                    mc = this.localMethodCalls.get(reg);
                }
                if (field == null) break block44;
                fieldSource = (String)obj.getUserValue();
                if (fieldSource == null) {
                    fieldSource = "";
                }
                mc = this.fieldMethodCalls.get(fieldSource + ":" + field.getName());
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue((Object)userValue);
            }
            return;
            try {
                methodName = this.getNameConstantOperand();
                if (mc != null) {
                    if (!signature.endsWith("V") && methodName.equals(mc.getName()) && signature.equals(mc.getSignature()) && !PossiblyRedundantMethodCalls.isRiskyName(className, methodName) && Arrays.equals(parms = mc.getParms(), parmConstants) && ((ln = this.getLineNumber(pc)) != mc.getLineNumber() || Math.abs(pc - mc.getPC()) < 10)) {
                        statistics = Statistics.getStatistics();
                        mi = statistics.getMethodStatistics(this.getClassConstantOperand(), methodName, signature);
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS.name(), PossiblyRedundantMethodCalls.getBugPriority(methodName, mi)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(methodName + signature));
                    }
                    if (seen == 184) {
                        this.staticMethodCalls.remove(className);
                    } else if (reg >= 0) {
                        this.localMethodCalls.remove(reg);
                    } else if (field != null) {
                        fieldSource = "";
                        if (this.stack.getStackDepth() > 0 && (fieldSource = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) {
                            fieldSource = "";
                        }
                        this.fieldMethodCalls.remove(fieldSource + ":" + field.getName());
                    }
                } else {
                    ln = this.getLineNumber(pc);
                    if (seen == 184) {
                        this.staticMethodCalls.put(className, new MethodCall(methodName, signature, parmConstants, pc, ln));
                    } else if (reg >= 0) {
                        this.localMethodCalls.put(reg, new MethodCall(methodName, signature, parmConstants, pc, ln));
                    } else if (field != null) {
                        obj = this.stack.getStackItem(parmCount);
                        fieldSource = (String)obj.getUserValue();
                        if (fieldSource == null) {
                            fieldSource = "";
                        }
                        this.fieldMethodCalls.put(fieldSource + ":" + field.getName(), new MethodCall(methodName, signature, parmConstants, pc, ln));
                    }
                }
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (userValue != null && this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    item.setUserValue(userValue);
                }
            }
        }
    }

    private static int getBugPriority(String methodName, MethodInfo mi) {
        if (mi.getNumBytes() >= highByteCountLimit || mi.getNumMethodCalls() >= highMethodCallLimit) {
            return 1;
        }
        if ("<clinit>".equals(methodName)) {
            return 3;
        }
        if (mi.getNumBytes() >= normalByteCountLimit || mi.getNumMethodCalls() >= normalMethodCallLimit) {
            return 2;
        }
        if (mi.getNumBytes() == 0 || mi.getNumMethodCalls() == 0) {
            return 3;
        }
        return 4;
    }

    private static boolean isRiskyName(String className, String methodName) {
        if (riskyClassNames.contains(className)) {
            return true;
        }
        for (String riskyName : riskyMethodNameContents) {
            if (methodName.indexOf(riskyName) < 0) continue;
            return true;
        }
        return methodName.contains("$");
    }

    private int getLineNumber(int pc) {
        LineNumberTable lnt = this.getMethod().getLineNumberTable();
        if (lnt == null) {
            return pc;
        }
        LineNumber[] lns = lnt.getLineNumberTable();
        if (lns == null) {
            return pc;
        }
        if (pc > lns[lns.length - 1].getStartPC()) {
            return lns[lns.length - 1].getLineNumber();
        }
        int lo = 0;
        int hi = lns.length - 2;
        int mid = 0;
        while (lo <= hi) {
            mid = lo + hi >>> 1;
            if (pc < lns[mid].getStartPC()) {
                hi = mid - 1;
                continue;
            }
            if (pc < lns[mid + 1].getStartPC()) break;
            lo = mid + 1;
        }
        return lns[mid].getLineNumber();
    }

    static {
        Integer prop;
        String[] userNames;
        riskyMethodNameContents = new HashSet<String>();
        highByteCountLimit = 200;
        highMethodCallLimit = 10;
        normalByteCountLimit = 50;
        normalMethodCallLimit = 4;
        riskyMethodNameContents.add("next");
        riskyMethodNameContents.add("add");
        riskyMethodNameContents.add("create");
        riskyMethodNameContents.add("append");
        riskyMethodNameContents.add("find");
        riskyMethodNameContents.add("put");
        riskyMethodNameContents.add("remove");
        riskyMethodNameContents.add("read");
        riskyMethodNameContents.add("write");
        riskyMethodNameContents.add("push");
        riskyMethodNameContents.add("pop");
        riskyMethodNameContents.add("scan");
        riskyMethodNameContents.add("skip");
        riskyMethodNameContents.add("clone");
        riskyMethodNameContents.add("close");
        riskyMethodNameContents.add("copy");
        riskyMethodNameContents.add("currentTimeMillis");
        riskyMethodNameContents.add("nanoTime");
        riskyMethodNameContents.add("newInstance");
        riskyMethodNameContents.add("noneOf");
        riskyMethodNameContents.add("allOf");
        riskyMethodNameContents.add("random");
        riskyMethodNameContents.add("beep");
        riskyMethodNameContents.add("emptyList");
        riskyMethodNameContents.add("emptySet");
        riskyMethodNameContents.add("emptyMap");
        String userNameProp = System.getProperty(PRMC_RISKY_FIELD_USER_KEY);
        if (userNameProp != null) {
            for (String name : userNames = userNameProp.split("\\s*,\\s*")) {
                riskyMethodNameContents.add(name);
            }
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_BYTECOUNT)) != null) {
            highByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_METHODCALLS)) != null) {
            highMethodCallLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_BYTECOUNT)) != null) {
            normalByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_METHODCALLS)) != null) {
            normalMethodCallLimit = prop;
        }
        riskyClassNames = new HashSet<String>();
        riskyClassNames.add("java/nio/ByteBuffer");
        riskyClassNames.add("java/io/DataInputStream");
        riskyClassNames.add("java/io/ObjectInputStream");
        riskyClassNames.add("java/util/Calendar");
        userNameProp = System.getProperty(PRMC_RISKY_CLASS_USER_KEY);
        if (userNameProp != null) {
            for (String name : userNames = userNameProp.split("\\s*,\\s*")) {
                riskyClassNames.add(name);
            }
        }
    }

    static class MethodCall {
        private final String methodName;
        private final String methodSignature;
        private final Object[] methodParms;
        private final int methodPC;
        private final int methodLineNumber;

        public MethodCall(String name, String signature, Object[] parms, int pc, int lineNumber) {
            this.methodName = name;
            this.methodSignature = signature;
            this.methodParms = parms;
            this.methodPC = pc;
            this.methodLineNumber = lineNumber;
        }

        public String getName() {
            return this.methodName;
        }

        public String getSignature() {
            return this.methodSignature;
        }

        public Object[] getParms() {
            return this.methodParms;
        }

        public int getPC() {
            return this.methodPC;
        }

        public int getLineNumber() {
            return this.methodLineNumber;
        }
    }
}

