/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class ReflectionOnObjectMethods
extends BytecodeScanningDetector {
    private static final Set<String> objectSigs = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, String[]> localClassTypes;
    private Map<String, String[]> fieldClassTypes;

    public ReflectionOnObjectMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.localClassTypes = new HashMap<Integer, String[]>();
            this.fieldClassTypes = new HashMap<String, String[]>();
            JavaClass cls = classContext.getJavaClass();
            Method staticInit = ReflectionOnObjectMethods.findStaticInitializer(cls);
            if (staticInit != null) {
                this.setupVisitorForClass(cls);
                this.doVisitMethod(staticInit);
            }
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.localClassTypes = null;
            this.fieldClassTypes = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localClassTypes.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer arraySize = null;
        String[] loadedTypes = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 189: {
                    if (!"java/lang/Class".equals(this.getClassConstantOperand())) return;
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    arraySize = (Integer)item.getConstant();
                    return;
                }
                case 83: {
                    if (this.stack.getStackDepth() < 3) return;
                    OpcodeStack.Item arrayItem = this.stack.getStackItem(2);
                    String[] arrayTypes = (String[])arrayItem.getUserValue();
                    if (arrayTypes == null) return;
                    OpcodeStack.Item valueItem = this.stack.getStackItem(0);
                    String type = (String)valueItem.getConstant();
                    if (type == null) return;
                    OpcodeStack.Item indexItem = this.stack.getStackItem(1);
                    Integer index = (Integer)indexItem.getConstant();
                    if (index == null) return;
                    arrayTypes[index.intValue()] = type;
                    return;
                }
                case 179: 
                case 181: {
                    OpcodeStack.Item item;
                    String[] arrayTypes;
                    String name = this.getNameConstantOperand();
                    if (this.stack.getStackDepth() >= 1 && (arrayTypes = (String[])(item = this.stack.getStackItem(0)).getUserValue()) != null) {
                        this.fieldClassTypes.put(name, arrayTypes);
                        return;
                    }
                    this.fieldClassTypes.remove(name);
                    return;
                }
                case 178: 
                case 180: {
                    String name = this.getNameConstantOperand();
                    loadedTypes = this.fieldClassTypes.get(name);
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    OpcodeStack.Item item;
                    String[] arrayTypes;
                    Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (this.stack.getStackDepth() >= 1 && (arrayTypes = (String[])(item = this.stack.getStackItem(0)).getUserValue()) != null) {
                        this.localClassTypes.put(reg, arrayTypes);
                        return;
                    }
                    this.localClassTypes.remove(reg);
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    loadedTypes = this.localClassTypes.get(reg);
                    return;
                }
                case 182: {
                    OpcodeStack.Item methodItem;
                    String methodName;
                    String cls = this.getClassConstantOperand();
                    if (!"java/lang/Class".equals(cls)) {
                        if (!"java/lang/reflect/Method".equals(cls)) return;
                        String method = this.getNameConstantOperand();
                        if (!"invoke".equals(method)) return;
                        if (this.stack.getStackDepth() < 3) return;
                        OpcodeStack.Item methodItem2 = this.stack.getStackItem(2);
                        String[] arrayTypes = (String[])methodItem2.getUserValue();
                        if (arrayTypes == null) return;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ROOM_REFLECTION_ON_OBJECT_METHODS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        return;
                    }
                    String method = this.getNameConstantOperand();
                    if (!"getMethod".equals(method)) return;
                    String sig = this.getSigConstantOperand();
                    if (!"(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;".equals(sig)) return;
                    if (this.stack.getStackDepth() < 2) return;
                    OpcodeStack.Item clsArgs = this.stack.getStackItem(0);
                    String[] arrayTypes = (String[])clsArgs.getUserValue();
                    if (arrayTypes == null) {
                        if (!clsArgs.isNull()) return;
                    }
                    if ((methodName = (String)(methodItem = this.stack.getStackItem(1)).getConstant()) == null) return;
                    String reflectionSig = ReflectionOnObjectMethods.buildReflectionSignature(methodName, arrayTypes);
                    if (!objectSigs.contains(reflectionSig)) return;
                    loadedTypes = arrayTypes == null ? new String[]{} : arrayTypes;
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() >= 1) {
                if (arraySize != null) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)new String[arraySize.intValue()]);
                } else if (loadedTypes != null) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)loadedTypes);
                }
            }
        }
    }

    private static String buildReflectionSignature(String methodName, String[] parmTypes) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(methodName);
        sb.append("(");
        if (parmTypes != null) {
            for (String type : parmTypes) {
                sb.append("L");
                if (type == null) {
                    return "";
                }
                sb.append(type);
                if (type.length() <= 1 && "IJ".indexOf(type) >= 0) continue;
                sb.append(";");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static Method findStaticInitializer(JavaClass cls) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (!"<clinit>".equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    static {
        objectSigs.add("equals(Ljava/lang/Object;)");
        objectSigs.add("finalize()");
        objectSigs.add("getClass()");
        objectSigs.add("hashCode()");
        objectSigs.add("notify()");
        objectSigs.add("notifyAll()");
        objectSigs.add("toString()");
        objectSigs.add("wait");
        objectSigs.add("wait(J)");
        objectSigs.add("wait(JI");
    }
}

