/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SideEffectConstructor
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private State state;

    public SideEffectConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.state = State.SAW_NOTHING;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        int pc = 0;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (this.state) {
                case SAW_NOTHING: {
                    if (seen == 183) {
                        String name = this.getNameConstantOperand();
                        if (!"<init>".equals(name)) return;
                        String sig = this.getSigConstantOperand();
                        int numArgs = Type.getArgumentTypes((String)sig).length;
                        if (this.stack.getStackDepth() <= numArgs) return;
                        OpcodeStack.Item caller = this.stack.getStackItem(numArgs);
                        if (caller.getRegisterNumber() == 0) return;
                        this.state = State.SAW_CTOR;
                        pc = this.getPC();
                        return;
                    }
                    if (seen != 177) return;
                    int depth = this.stack.getStackDepth();
                    int i = 0;
                    while (i < depth) {
                        OpcodeStack.Item item = this.stack.getStackItem(i);
                        Integer secPC = (Integer)item.getUserValue();
                        if (secPC != null) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SEC_SIDE_EFFECT_CONSTRUCTOR.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, secPC.intValue()));
                            return;
                        }
                        ++i;
                    }
                    return;
                }
                case SAW_CTOR: {
                    if (seen == 87 || seen == 177) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SEC_SIDE_EFFECT_CONSTRUCTOR.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SAW_NOTHING;
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (pc != 0 && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)pc);
            }
        }
    }

    private static enum State {
        SAW_NOTHING,
        SAW_CTOR;

    }
}

