/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.CodeByteUtils;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SillynessPotPourri
extends BytecodeScanningDetector {
    private static final Set<String> collectionInterfaces = new HashSet<String>();
    private static final Set<String> oddMissingEqualsClasses;
    private static final String LITERAL = "literal";
    private static final Pattern APPEND_PATTERN;
    private static JavaClass calendarClass;
    private static Map<String, Integer> methodsThatAreSillyOnStringLiterals;
    private final BugReporter bugReporter;
    private final Set<String> toStringClasses;
    private OpcodeStack stack;
    private int[] lastPCs;
    private int lastOpcode;
    private int lastReg;
    private boolean lastIfEqWasBoolean;
    private boolean lastLoadWasString;
    private Map<Integer, BitSet> branchTargets;
    private Set<String> staticConstants;

    public SillynessPotPourri(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.toStringClasses = new HashSet<String>();
    }

    public void visitField(Field field) {
        if ("serialVersionUID".equals(field.getName()) && (field.getAccessFlags() & 8) != 0 && (field.getAccessFlags() & 2) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_SERIALVER_SHOULD_BE_PRIVATE.name(), 3).addClass((PreorderVisitor)this).addField((PreorderVisitor)this));
        }
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.lastPCs = new int[4];
            this.branchTargets = new HashMap<Integer, BitSet>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.lastPCs = null;
            this.branchTargets = null;
            this.staticConstants = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.lastOpcode = -1;
        this.lastReg = -1;
        this.lastIfEqWasBoolean = false;
        this.lastLoadWasString = false;
        Arrays.fill(this.lastPCs, -1);
        this.branchTargets.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        int reg = -1;
        String userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (SillynessPotPourri.isBranchByteCode(seen)) {
                Integer branchTarget = this.getBranchTarget();
                BitSet branchInsSet = this.branchTargets.get(branchTarget);
                if (branchInsSet == null) {
                    branchInsSet = new BitSet();
                    this.branchTargets.put(branchTarget, branchInsSet);
                }
                branchInsSet.set(this.getPC());
            }
            if (seen == 153 || seen == 158 || seen == 154) {
                this.checkForEmptyStringAndNullChecks(seen);
            }
            if (seen == 153 || seen == 154 || seen == 157) {
                this.checkSizeEquals0();
            }
            if (seen == 153) {
                this.checkNullAndInstanceOf();
            }
            if (seen == 154) {
                this.checkNotEqualsStringBuilderLength();
            } else if (seen == 153) {
                this.checkEqualsStringBufferLength();
            } else if (seen == 172 && this.lastIfEqWasBoolean) {
                this.checkForUselessTernaryReturn();
            } else if (seen == 20) {
                this.checkApproximationsOfMathConstants();
            } else if (seen == 151) {
                this.checkCompareToNaNDouble();
            } else if (seen == 149) {
                this.checkCompareToNaNFloat();
            } else if (OpcodeUtils.isAStore(seen)) {
                reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                this.checkStutterdAssignment(seen, reg);
                this.checkImmutableUsageOfStringBuilder(reg);
            } else if (OpcodeUtils.isALoad(seen)) {
                this.sawLoad(seen);
            } else if (seen >= 3 && seen <= 6) {
                userValue = this.sawIntConst(userValue);
            } else if (seen == 52) {
                this.checkImproperToCharArrayUse();
            } else if (seen == 184) {
                userValue = this.sawInvokeStatic(userValue);
            } else if (seen == 182) {
                userValue = this.sawInvokeVirtual(userValue);
            } else if (seen == 183) {
                this.sawInvokeSpecial();
            } else if (seen == 185) {
                userValue = this.sawInvokeInterface(userValue);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                if (userValue != null) {
                    item.setUserValue(userValue);
                } else if ("iterator".equals(item.getUserValue()) && seen == 180 || seen == 25 || seen >= 42 && seen <= 45) {
                    item.setUserValue(null);
                }
            }
            this.lastOpcode = seen;
            this.lastReg = reg;
            System.arraycopy(this.lastPCs, 1, this.lastPCs, 0, 3);
            this.lastPCs[3] = this.getPC();
        }
    }

    private void checkImproperToCharArrayUse() {
        OpcodeStack.Item item;
        String ic;
        if (this.stack.getStackDepth() > 0 && "iconst".equals(ic = (String)(item = this.stack.getStackItem(0)).getUserValue())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_CHARAT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private String sawIntConst(String userValue) {
        OpcodeStack.Item item;
        String tca;
        if (this.stack.getStackDepth() > 0 && "toCharArray".equals(tca = (String)(item = this.stack.getStackItem(0)).getUserValue())) {
            userValue = "iconst";
        }
        return userValue;
    }

    private void sawLoad(int seen) {
        LocalVariable lv;
        this.lastLoadWasString = false;
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC((LocalVariableTable)lvt, (int)RegisterUtils.getALoadReg((DismantleBytecode)this, seen), (int)this.getPC())) != null) {
            this.lastLoadWasString = "Ljava/lang/String;".equals(lv.getSignature());
        }
    }

    private void checkStutterdAssignment(int seen, int reg) {
        if (seen == this.lastOpcode && reg == this.lastReg) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STUTTERED_ASSIGNMENT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkImmutableUsageOfStringBuilder(int reg) {
        OpcodeStack.Item item;
        String mName;
        if (this.stack.getStackDepth() > 0 && (mName = (String)(item = this.stack.getStackItem(0)).getUserValue()) != null) {
            if ("trim".equals(mName)) {
                item.setUserValue(null);
            } else {
                int appendReg;
                Matcher m = APPEND_PATTERN.matcher(mName);
                if (m.matches() && reg == (appendReg = Integer.parseInt(m.group(1)))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STRINGBUILDER_IS_MUTABLE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }

    private void checkCompareToNaNFloat() {
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Float f1 = (Float)item.getConstant();
            item = this.stack.getStackItem(1);
            Float f2 = (Float)item.getConstant();
            if (f1 != null && f1.isNaN() || f2 != null && f2.isNaN()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISNAN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("float").addString("Float"));
            }
        }
    }

    private void checkCompareToNaNDouble() {
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Double d1 = (Double)item.getConstant();
            item = this.stack.getStackItem(1);
            Double d2 = (Double)item.getConstant();
            if (d1 != null && d1.isNaN() || d2 != null && d2.isNaN()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISNAN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("double").addString("Double"));
            }
        }
    }

    private void checkApproximationsOfMathConstants() {
        Constant con = this.getConstantRefOperand();
        if (con instanceof ConstantDouble) {
            double d = ((ConstantDouble)con).getBytes();
            double piDelta = Math.abs(d - Math.PI);
            double eDelta = Math.abs(d - Math.E);
            if (piDelta > 0.0 && piDelta < 0.002 || eDelta > 0.0 && eDelta < 0.002) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_MATH_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void checkForUselessTernaryReturn() {
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[0] != -1 && (0xFF & bytes[this.lastPCs[3]]) == 3 && (0xFF & bytes[this.lastPCs[2]]) == 167 && (0xFF & bytes[this.lastPCs[1]]) == 4 && (0xFF & bytes[this.lastPCs[0]]) == 153 && this.getMethod().getSignature().endsWith("Z")) {
            boolean bug = true;
            BitSet branchInsSet = this.branchTargets.get(this.lastPCs[1]);
            if (branchInsSet != null) {
                bug = false;
            }
            if ((branchInsSet = this.branchTargets.get(this.lastPCs[3])) != null && branchInsSet.cardinality() > 1) {
                bug = false;
            }
            if (bug) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USELESS_TERNARY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void checkEqualsStringBufferLength() {
        int lengthIndex;
        ConstantMethodref lengthMR;
        int nandtIndex;
        ConstantNameAndType cnt;
        int consIndex;
        Constant c;
        ConstantMethodref toStringMR;
        String toStringCls;
        int toStringIndex;
        ConstantPool pool;
        Constant cmr;
        int loadIns;
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            this.lastIfEqWasBoolean = "Z".equals(itm.getSignature());
        }
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[1] != -1 && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && ((loadIns = CodeByteUtils.getbyte(bytes, this.lastPCs[2])) == 18 || loadIns == 19) && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 182 && (cmr = (pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1))) instanceof ConstantMethodref && (toStringCls = (toStringMR = (ConstantMethodref)cmr).getClass(pool)).startsWith("java.lang.&&StringBu") && (c = pool.getConstant(consIndex = CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1))) instanceof ConstantString && "".equals(((ConstantString)c).getBytes(pool)) && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "equals".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_STRINGBUILDER_LENGTH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkNotEqualsStringBuilderLength() {
        int lengthIndex;
        ConstantMethodref lengthMR;
        int nandtIndex;
        ConstantNameAndType cnt;
        int toStringIndex;
        ConstantPool pool;
        ConstantMethodref toStringMR;
        String toStringCls;
        byte[] bytes = this.getCode().getCode();
        if (this.lastPCs[2] != -1 && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == 182 && (toStringCls = (toStringMR = (ConstantMethodref)(pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[2] + 1))).getClass(pool)).startsWith("java.lang.StringBu") && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "length".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_STRINGBUILDER_LENGTH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkNullAndInstanceOf() {
        int ifNullTarget;
        int ins2;
        int ins0;
        byte[] bytes = this.getCode().getCode();
        if (!(this.lastPCs[0] == -1 || CodeByteUtils.getbyte(bytes, this.lastPCs[1]) != 198 || CodeByteUtils.getbyte(bytes, this.lastPCs[3]) != 193 || (ins0 = CodeByteUtils.getbyte(bytes, this.lastPCs[0])) != 25 && ins0 != 42 && ins0 != 43 && ins0 != 44 && ins0 != 45 || ins0 != (ins2 = CodeByteUtils.getbyte(bytes, this.lastPCs[0])) || ins0 == 25 && CodeByteUtils.getbyte(bytes, this.lastPCs[0] + 1) != CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1) || (ifNullTarget = this.lastPCs[1] + CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1)) != this.getBranchTarget())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NULL_BEFORE_INSTANCEOF.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkSizeEquals0() {
        OpcodeStack.Item item;
        if (this.stack.getStackDepth() == 1 && "size".equals((item = this.stack.getStackItem(0)).getUserValue())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_ISEMPTY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void checkForEmptyStringAndNullChecks(int seen) {
        if (this.lastLoadWasString && this.lastPCs[0] != -1) {
            int mpoolIndex;
            ConstantMethodref cmr;
            int nandtIndex;
            ConstantPool pool;
            ConstantNameAndType cnt;
            int nextOp;
            int brOffset;
            byte[] bytes = this.getCode().getCode();
            int loadIns = CodeByteUtils.getbyte(bytes, this.lastPCs[2]);
            int n = brOffset = loadIns == 25 ? 11 : 10;
            if ((loadIns >= 42 && loadIns <= 45 || loadIns == 25) && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == loadIns && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 198 && CodeByteUtils.getbyte(bytes, this.lastPCs[0]) == loadIns && (loadIns != 25 || CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1) == CodeByteUtils.getbyte(bytes, this.lastPCs[0] + 1)) && (seen == 154 ? CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) > brOffset : CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) == brOffset) && (nextOp = CodeByteUtils.getbyte(bytes, this.getNextPC())) != 167 && nextOp != 200 && "length".equals((cnt = (ConstantNameAndType)(pool = this.getConstantPool()).getConstant(nandtIndex = (cmr = (ConstantMethodref)pool.getConstant(mpoolIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_SUSPECT_STRING_TEST.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private static boolean isBranchByteCode(int seen) {
        return seen >= 153 && seen <= 167 || seen == 198 || seen == 199 || seen == 200;
    }

    private String sawInvokeStatic(String userValue) {
        OpcodeStack.Item item;
        String format;
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        if ("java/lang/System".equals(className)) {
            if ("getProperties".equals(methodName)) {
                userValue = "getProperties";
            } else if ("arraycopy".equals(methodName) && this.stack.getStackDepth() >= 5) {
                OpcodeStack.Item item2 = this.stack.getStackItem(2);
                String sig = item2.getSignature();
                if (sig.charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if ((sig = (item2 = this.stack.getStackItem(4)).getSignature()).charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("java/lang/reflect/Array".equals(className)) {
            OpcodeStack.Item item3;
            String sig;
            int offset = -1;
            if ("getLength".equals(methodName)) {
                offset = 0;
            } else if (methodName.startsWith("get")) {
                offset = 1;
            } else if (methodName.startsWith("set")) {
                offset = 2;
            }
            if (offset >= 0 && this.stack.getStackDepth() > offset && (sig = (item3 = this.stack.getStackItem(offset)).getSignature()).charAt(0) != '[' && !"Ljava/lang/Object;".equals(sig)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_ARRAY_PARM.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("java/lang/String".equals(className) && "format".equals(methodName) && (format = (String)(item = this.stack.getStackItem(1)).getConstant()) != null && !format.contains("%")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STATIC_FORMAT_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        return userValue;
    }

    private String sawInvokeVirtual(String userValue) throws ClassNotFoundException {
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        if ("java/util/BitSet".equals(className)) {
            this.bitSetSilliness(methodName);
        } else if ("java/lang/StringBuilder".equals(className) || "java/lang/StringBuffer".equals(className)) {
            userValue = this.stringBufferSilliness(userValue, methodName);
        } else if ("java/lang/String".equals(className)) {
            userValue = this.stringSilliness(userValue, methodName, this.getSigConstantOperand());
        } else if ("equals(Ljava/lang/Object;)Z".equals(methodName + this.getSigConstantOperand())) {
            this.equalsSilliness(className);
        } else if ("java/lang/Boolean".equals(className) && "booleanValue".equals(methodName)) {
            this.booleanSilliness();
        } else if (("java/util/GregorianCalendar".equals(className) || "java/util/Calendar".equals(className)) && ("after".equals(methodName) || "before".equals(methodName))) {
            this.calendarBeforeAfterSilliness();
        } else if ("java/util/Properties".equals(className)) {
            this.propertiesSilliness(methodName);
        } else if ("toString".equals(methodName) && "java/lang/Object".equals(className)) {
            this.defaultToStringSilliness();
        }
        return userValue;
    }

    private void bitSetSilliness(String methodName) {
        OpcodeStack.Item item;
        Object o;
        if (("clear".equals(methodName) || "flip".equals(methodName) || "get".equals(methodName) || "set".equals(methodName)) && this.stack.getStackDepth() > 0 && (o = (item = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)o < 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NEGATIVE_BITSET_ITEM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private String stringBufferSilliness(String userValue, String methodName) {
        if ("append".equals(methodName) && this.stack.getStackDepth() > 1) {
            String literal;
            Matcher m;
            String existingAppend;
            OpcodeStack.Item valItem = this.stack.getStackItem(0);
            OpcodeStack.Item sbItem = this.stack.getStackItem(1);
            Object constant = valItem.getConstant();
            boolean argIsLiteralString = constant instanceof String && ((String)constant).length() > 0;
            boolean bl = argIsLiteralString = argIsLiteralString && !this.looksLikeStaticFieldValue((String)constant);
            if (argIsLiteralString && (existingAppend = (String)sbItem.getUserValue()) != null && (m = APPEND_PATTERN.matcher(existingAppend)).matches() && LITERAL.equals(m.group(2))) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_DOUBLE_APPENDED_LITERALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                argIsLiteralString = false;
            }
            String string = literal = argIsLiteralString ? LITERAL : "";
            if (sbItem.getRegisterNumber() > -1) {
                userValue = "append:" + sbItem.getRegisterNumber() + ':' + literal;
            } else {
                userValue = (String)sbItem.getUserValue();
                if (userValue != null && (m = APPEND_PATTERN.matcher(userValue)).matches()) {
                    userValue = "append:" + m.group(1) + ':' + literal;
                }
            }
        }
        return userValue;
    }

    private String stringSilliness(String userValue, String methodName, String signature) {
        OpcodeStack.Item item;
        OpcodeStack.Item itm;
        Object constant;
        Integer stackOffset = methodsThatAreSillyOnStringLiterals.get(methodName + signature);
        if (stackOffset != null && this.stack.getStackDepth() > stackOffset && (constant = (itm = this.stack.getStackItem(stackOffset.intValue())).getConstant()) != null && constant.getClass().equals(String.class) && itm.getXField() == null) {
            int priority = 2;
            if (Type.getArgumentTypes((String)this.getSigConstantOperand()).length > 0) {
                priority = 3;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_CONVERSION_OF_STRING_LITERAL.name(), priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
        }
        if ("intern".equals(methodName)) {
            OpcodeStack.Item item2;
            String owningMethod = this.getMethod().getName();
            if (!"<clinit>".equals(owningMethod) && this.stack.getStackDepth() > 0 && (item2 = this.stack.getStackItem(0)).getConstant() != null) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INTERN_ON_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("toCharArray".equals(methodName)) {
            userValue = "toCharArray";
        } else if ("toLowerCase".equals(methodName) || "toUpperCase".equals(methodName)) {
            userValue = "IgnoreCase";
        } else if ("equalsIgnoreCase".equals(methodName) || "compareToIgnoreCase".equals(methodName)) {
            if (this.stack.getStackDepth() > 1) {
                String parm;
                item = this.stack.getStackItem(1);
                if ("IgnoreCase".equals(item.getUserValue())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USELESS_CASING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if ("".equals(parm = (String)(item = this.stack.getStackItem(0)).getConstant())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EMPTY_CASING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("trim".equals(methodName)) {
            userValue = "trim";
        } else if ("length".equals(methodName)) {
            if (this.stack.getStackDepth() > 0 && "trim".equals((item = this.stack.getStackItem(0)).getUserValue())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TEMPORARY_TRIM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("equals".equals(methodName)) {
            if (this.stack.getStackDepth() > 1 && "trim".equals((item = this.stack.getStackItem(1)).getUserValue())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TEMPORARY_TRIM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("toString".equals(methodName)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_TOSTRING_ON_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        return userValue;
    }

    private void equalsSilliness(String className) {
        try {
            String clsName;
            OpcodeStack.Item item;
            JavaClass cls = Repository.lookupClass((String)className);
            if (cls.isEnum()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EQUALS_ON_ENUM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (this.stack.getStackDepth() >= 2 && (cls = (item = this.stack.getStackItem(1)).getJavaClass()) != null && oddMissingEqualsClasses.contains(clsName = cls.getClassName())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_EQUALS_ON_STRING_BUILDER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private void booleanSilliness() {
        byte[] bytes;
        int ifeq;
        int range1Size;
        if (this.lastPCs[0] != -1 && (range1Size = this.lastPCs[2] - this.lastPCs[0]) == this.getNextPC() - this.lastPCs[3] && (ifeq = 0xFF & (bytes = this.getCode().getCode())[this.lastPCs[2]]) == 153) {
            int start1 = this.lastPCs[0];
            int start2 = this.lastPCs[3];
            boolean found = true;
            for (int i = 0; i < range1Size; ++i) {
                if (bytes[start1 + i] == bytes[start2 + i]) continue;
                found = false;
                break;
            }
            if (found) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INVALID_BOOLEAN_NULL_CHECK.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void calendarBeforeAfterSilliness() {
        OpcodeStack.Item item;
        String itemSig;
        if (!(this.stack.getStackDepth() <= 1 || "Ljava/lang/Object;".equals(itemSig = (item = this.stack.getStackItem(0)).getSignature()) || "Ljava/util/Calendar;".equals(itemSig) || "Ljava/util/GregorianCalendar;".equals(itemSig))) {
            try {
                JavaClass cls = Repository.lookupClass((String)itemSig.substring(1, itemSig.length() - 1));
                if (!cls.instanceOf(calendarClass)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_INVALID_CALENDAR_COMPARE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    private void defaultToStringSilliness() throws ClassNotFoundException {
        OpcodeStack.Item item;
        JavaClass toStringClass;
        if (this.stack.getStackDepth() >= 1 && (toStringClass = (item = this.stack.getStackItem(0)).getJavaClass()) != null) {
            String toStringClassName = toStringClass.getClassName();
            if (!(toStringClass.isInterface() || toStringClass.isAbstract() || "java.lang.Object".equals(toStringClassName) || "java.lang.String".equals(toStringClassName) || !this.toStringClasses.add(toStringClassName))) {
                try {
                    JavaClass cls = Repository.lookupClass((String)toStringClassName);
                    if (!this.hasToString(cls)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NON_USEFUL_TOSTRING.name(), toStringClass.isFinal() ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                }
            }
        }
    }

    private void propertiesSilliness(String methodName) {
        OpcodeStack.Item item;
        if (("get".equals(methodName) || "getProperty".equals(methodName)) && this.stack.getStackDepth() > 1 && "getProperties".equals((item = this.stack.getStackItem(1)).getUserValue())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_GETPROPERTY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private String sawInvokeInterface(String userValue) {
        OpcodeStack.Item item;
        String method;
        String className = this.getClassConstantOperand();
        if ("java/util/Map".equals(className)) {
            method = this.getNameConstantOperand();
            if ("keySet".equals(method)) {
                userValue = "keySet";
            }
        } else if ("java/util/Set".equals(className)) {
            OpcodeStack.Item item2;
            method = this.getNameConstantOperand();
            if ("contains".equals(method) && this.stack.getStackDepth() >= 2 && "keySet".equals((item2 = this.stack.getStackItem(1)).getUserValue())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_CONTAINSKEY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        } else if ("java/util/List".equals(className)) {
            method = this.getNameConstantOperand();
            if ("iterator".equals(method)) {
                userValue = "iterator";
            }
        } else if ("java/util/Iterator".equals(className) && "next".equals(method = this.getNameConstantOperand()) && this.stack.getStackDepth() >= 1 && "iterator".equals((item = this.stack.getStackItem(0)).getUserValue())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_GET0.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (collectionInterfaces.contains(className) && "size".equals(method = this.getNameConstantOperand())) {
            userValue = "size";
        }
        return userValue;
    }

    private void sawInvokeSpecial() {
        double v;
        OpcodeStack.Item item;
        Object constant;
        String className = this.getClassConstantOperand();
        if ("java/lang/StringBuffer".equals(className) || "java/lang/StringBuilder".equals(className)) {
            String methodName = this.getNameConstantOperand();
            if ("<init>".equals(methodName)) {
                OpcodeStack.Item item2;
                String con;
                String signature = this.getSigConstantOperand();
                if ("(I)V".equals(signature)) {
                    int parm;
                    OpcodeStack.Item item3;
                    Object o;
                    if (this.lastOpcode == 16 && this.stack.getStackDepth() > 0 && (o = (item3 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (parm = ((Integer)o).intValue()) > 32 && parm < 127 && parm != 64 && parm % 10 != 0 && parm % 5 != 0) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_NO_CHAR_SB_CTOR.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0 && "".equals(con = (String)(item2 = this.stack.getStackItem(0)).getConstant())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_STRINGBUFFER_WITH_EMPTY_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        } else if ("java/math/BigDecimal".equals(className) && this.stack.getStackDepth() > 0 && (constant = (item = this.stack.getStackItem(0)).getConstant()) instanceof Double && (v = ((Double)constant).doubleValue()) != 0.0 && v != 1.0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SPP_USE_BIGDECIMAL_STRING_CTOR.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private boolean looksLikeStaticFieldValue(String constant) {
        if (this.staticConstants == null) {
            Field[] fields;
            this.staticConstants = new HashSet<String>();
            for (Field f : fields = this.getClassContext().getJavaClass().getFields()) {
                ConstantValue cv;
                if ((f.getAccessFlags() & 0x18) != 24 || !"Ljava/lang/String;".equals(f.getSignature()) || (cv = f.getConstantValue()) == null) continue;
                int cvIndex = cv.getConstantValueIndex();
                this.staticConstants.add(this.getConstantPool().getConstantString(cvIndex, (byte)8));
            }
        }
        return this.staticConstants.contains(constant);
    }

    private boolean hasToString(JavaClass cls) throws ClassNotFoundException {
        do {
            for (Method m : cls.getMethods()) {
                if (!"toString".equals(m.getName()) || !"()Ljava/lang/String;".equals(m.getSignature())) continue;
                return true;
            }
        } while (!"java.lang.Object".equals((cls = cls.getSuperClass()).getClassName()));
        return false;
    }

    static {
        collectionInterfaces.add("java/util/Collection");
        collectionInterfaces.add("java/util/List");
        collectionInterfaces.add("java/util/Set");
        collectionInterfaces.add("java/util/SortedSet");
        collectionInterfaces.add("java/util/Map");
        collectionInterfaces.add("java/util/SortedMap");
        oddMissingEqualsClasses = new HashSet<String>();
        oddMissingEqualsClasses.add("java.lang.StringBuffer");
        oddMissingEqualsClasses.add("java.lang.StringBuilder");
        APPEND_PATTERN = Pattern.compile("append:([0-9]+):(.*)");
        try {
            calendarClass = Repository.lookupClass((String)"java/util/Calendar");
        }
        catch (ClassNotFoundException cnfe) {
            calendarClass = null;
        }
        methodsThatAreSillyOnStringLiterals = new HashMap<String, Integer>();
        methodsThatAreSillyOnStringLiterals.put("toLowerCase()Ljava/lang/String;", Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put("toUpperCase()Ljava/lang/String;", Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put("toLowerCase(Ljava/util/Locale;)Ljava/lang/String;", Values.ONE);
        methodsThatAreSillyOnStringLiterals.put("toUpperCase(Ljava/util/Locale;)Ljava/lang/String;", Values.ONE);
        methodsThatAreSillyOnStringLiterals.put("trim()Ljava/lang/String;", Values.ZERO);
        methodsThatAreSillyOnStringLiterals.put("isEmpty()Z", Values.ZERO);
    }
}

