/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class StaticArrayCreatedInMethod
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private int arraySize;
    private int storeCount;
    private State state;

    public StaticArrayCreatedInMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        if (!"<clinit>".equals(this.getMethodName())) {
            this.state = State.SEEN_NOTHING;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SEEN_NOTHING: {
                if (seen == 16) {
                    this.arraySize = this.getIntConstant();
                    if (this.arraySize <= 0) break;
                    this.state = State.SEEN_ARRAY_SIZE;
                    break;
                }
                if (seen < 2 || seen > 8) break;
                this.arraySize = seen - 2 - 1;
                if (this.arraySize <= 0) break;
                this.state = State.SEEN_ARRAY_SIZE;
                break;
            }
            case SEEN_ARRAY_SIZE: {
                if (seen == 189 || seen == 188) {
                    this.state = State.SEEN_NEWARRAY;
                    this.storeCount = 0;
                    break;
                }
                this.state = State.SEEN_NOTHING;
                break;
            }
            case SEEN_NEWARRAY: {
                if (seen == 89) {
                    this.state = State.SEEN_DUP;
                    break;
                }
                this.state = State.SEEN_NOTHING;
                break;
            }
            case SEEN_DUP: {
                int index;
                if (seen == 16) {
                    index = this.getIntConstant();
                } else if (seen >= 2 && seen <= 8) {
                    index = seen - 2 - 1;
                } else {
                    this.state = State.SEEN_NOTHING;
                    return;
                }
                if (index != this.storeCount) {
                    this.state = State.SEEN_NOTHING;
                    break;
                }
                this.state = State.SEEN_INDEX;
                break;
            }
            case SEEN_INDEX: {
                if (seen == 18 || seen == 19) {
                    this.state = State.SEEN_LDC;
                    break;
                }
                this.state = State.SEEN_NOTHING;
                break;
            }
            case SEEN_LDC: {
                if (seen < 79 || seen > 86) break;
                if (++this.storeCount == this.arraySize) {
                    this.state = State.SEEN_INDEX_STORE;
                    break;
                }
                this.state = State.SEEN_NEWARRAY;
                break;
            }
            case SEEN_INDEX_STORE: {
                if (seen == 58 || seen >= 75 && seen <= 78) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SACM_STATIC_ARRAY_CREATED_IN_METHOD.name(), this.arraySize < 3 ? 3 : (this.arraySize < 10 ? 2 : 1)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
                }
                this.state = State.SEEN_NOTHING;
            }
        }
    }

    static enum State {
        SEEN_NOTHING,
        SEEN_ARRAY_SIZE,
        SEEN_NEWARRAY,
        SEEN_DUP,
        SEEN_INDEX,
        SEEN_LDC,
        SEEN_INDEX_STORE;

    }
}

