/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class StutteredMethodArguments
extends BytecodeScanningDetector {
    private static Set<String> ignorableSignatures = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String processedPackageName;
    private String processedMethodName;

    public StutteredMethodArguments(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.processedPackageName = classContext.getJavaClass().getPackageName();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.processedPackageName = null;
        }
    }

    public void visitCode(Code obj) {
        try {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.processedMethodName = this.getMethod().getName();
            super.visitCode(obj);
        }
        finally {
            this.processedMethodName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        String fieldSource = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String clsName = this.getClassConstantOperand();
                    int slashPos = clsName.lastIndexOf(47);
                    String packageName = slashPos >= 0 ? clsName.substring(0, slashPos) : "";
                    if (!SignatureUtils.similarPackages(this.processedPackageName, packageName, 2)) return;
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    String methodInfo = clsName + ":" + methodName + signature;
                    if (this.processedMethodName.equals(methodName)) return;
                    if (ignorableSignatures.contains(methodInfo)) return;
                    Type[] parms = Type.getArgumentTypes((String)signature);
                    if (parms.length <= 1) return;
                    if (this.stack.getStackDepth() <= parms.length) return;
                    if (!StutteredMethodArguments.duplicateArguments(this.stack, parms)) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SMA_STUTTERED_METHOD_ARGUMENTS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
                case 178: 
                case 180: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    if (reg >= 0) {
                        fieldSource = String.valueOf(reg);
                        return;
                    }
                    XField f = item.getXField();
                    if (f != null) {
                        fieldSource = f.getClassName() + ':' + f.getName();
                        return;
                    }
                    fieldSource = "";
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (fieldSource != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)fieldSource);
            }
        }
    }

    private static boolean duplicateArguments(OpcodeStack opStack, Type ... parms) {
        HashSet<String> args = new HashSet<String>();
        for (int i = 0; i < parms.length; ++i) {
            OpcodeStack.Item item = opStack.getStackItem(i);
            String signature = item.getSignature();
            if (!signature.startsWith("L") || signature.startsWith("Ljava/lang/") || item.getConstant() != null) continue;
            String arg = null;
            int reg = item.getRegisterNumber();
            if (reg >= 0) {
                arg = String.valueOf(reg);
            } else {
                XField f = item.getXField();
                if (f != null) {
                    String fieldSource = (String)item.getUserValue();
                    if (fieldSource == null) {
                        fieldSource = "";
                    }
                    arg = fieldSource + '|' + f.getClassName() + ':' + f.getName();
                }
            }
            if (arg == null) continue;
            if (args.contains(arg = arg + "--" + parms[i].getSignature())) {
                return true;
            }
            args.add(arg);
        }
        return false;
    }

    static {
        ignorableSignatures.add("java/util/Map:put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    }
}

