/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousCloneAlgorithm
extends BytecodeScanningDetector {
    private static JavaClass cloneableClass;
    private static Map<String, Integer> changingMethods;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public SuspiciousCloneAlgorithm(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (cloneableClass == null) {
            return;
        }
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.implementationOf(cloneableClass)) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (!m.isStatic() && "clone".equals(m.getName()) && "()Ljava/lang/Object;".equals(m.getSignature())) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        boolean srcField = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 42: {
                    srcField = true;
                    return;
                }
                case 89: {
                    if (this.stack.getStackDepth() <= 0) return;
                    item = this.stack.getStackItem(0);
                    if (item.getUserValue() == null) return;
                    srcField = true;
                    return;
                }
                case 180: {
                    if (this.stack.getStackDepth() <= 0) return;
                    item = this.stack.getStackItem(0);
                    if (item.getRegisterNumber() != 0) return;
                    srcField = true;
                    return;
                }
                case 181: {
                    if (this.stack.getStackDepth() < 2) return;
                    item = this.stack.getStackItem(1);
                    if (item.getRegisterNumber() != 0) {
                        if (item.getUserValue() == null) return;
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SCA_SUSPICIOUS_CLONE_ALGORITHM.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
                case 182: 
                case 185: {
                    String name;
                    Integer priority;
                    String sig = this.getSigConstantOperand();
                    int numArgs = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() <= numArgs) return;
                    OpcodeStack.Item item2 = this.stack.getStackItem(numArgs);
                    if (item2.getRegisterNumber() != 0) {
                        if (item2.getUserValue() == null) return;
                    }
                    if ((priority = changingMethods.get(name = this.getNameConstantOperand())) == null) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SCA_SUSPICIOUS_CLONE_ALGORITHM.name(), priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (srcField && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    static {
        try {
            cloneableClass = Repository.lookupClass((String)"java/lang/Cloneable");
            Integer normal = 2;
            Integer low = 3;
            changingMethods = new HashMap<String, Integer>();
            changingMethods.put("add", normal);
            changingMethods.put("addAll", normal);
            changingMethods.put("put", normal);
            changingMethods.put("putAll", normal);
            changingMethods.put("insert", low);
            changingMethods.put("set", low);
        }
        catch (ClassNotFoundException cnfe) {
            cloneableClass = null;
        }
    }
}

