/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SuspiciousJDKVersionUse
extends BytecodeScanningDetector {
    private static final Map<Integer, String> VER_REG_EX = new HashMap<Integer, String>();
    private static final Map<Integer, Integer> HUMAN_VERSIONS;
    private static final Pattern jarPattern;
    private static final String SJVU_JDKHOME = "fb-contrib.sjvu.jdkhome";
    private final Map<String, File> versionPaths;
    private final Map<Integer, Map<String, Set<String>>> validMethodsByVersion;
    private final Map<String, String> superNames;
    private final Map<Integer, ZipFile> jdkZips;
    private File jdksRoot = null;
    private Integer clsMajorVersion;
    private ZipFile jdkZip;
    private final BugReporter bugReporter;

    public SuspiciousJDKVersionUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.versionPaths = new HashMap<String, File>();
        this.jdkZips = new HashMap<Integer, ZipFile>();
        this.validMethodsByVersion = new HashMap<Integer, Map<String, Set<String>>>();
        this.superNames = new HashMap<String, String>();
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.clsMajorVersion = classContext.getJavaClass().getMajor();
            this.jdkZip = this.jdkZips.get(this.clsMajorVersion);
            if (this.jdkZip == null) {
                File rtJar = this.getRTJarFile();
                if (rtJar == null) {
                    rtJar = SuspiciousJDKVersionUse.getRTJarFromProperty(this.clsMajorVersion);
                }
                if (rtJar != null) {
                    this.jdkZip = new ZipFile(rtJar);
                    this.jdkZips.put(this.clsMajorVersion, this.jdkZip);
                }
            }
            if (this.jdkZip == null) {
                return;
            }
            super.visitClassContext(classContext);
        }
        catch (IOException iOException) {
        }
        finally {
            this.clsMajorVersion = null;
            this.jdkZip = null;
        }
    }

    public void sawOpcode(int seen) {
        try {
            String clsName;
            if ((seen == 182 || seen == 184 || seen == 183) && ((clsName = this.getClassConstantOperand()).startsWith("java/") || clsName.startsWith("javax/"))) {
                Method m = this.findCalledMethod();
                if (m == null) {
                    return;
                }
                Map<String, Set<String>> validMethods = this.validMethodsByVersion.get(this.clsMajorVersion);
                if (validMethods == null) {
                    validMethods = new HashMap<String, Set<String>>();
                    this.validMethodsByVersion.put(this.clsMajorVersion, validMethods);
                }
                if (!this.isValid(validMethods, clsName)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SJVU_SUSPICIOUS_JDK_VERSION_USE.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Method findCalledMethod() {
        try {
            JavaClass clss = Repository.lookupClass((String)this.getClassConstantOperand());
            Method[] methods = clss.getMethods();
            String calledMethod = this.getNameConstantOperand();
            String calledSignature = this.getSigConstantOperand();
            for (Method m : methods) {
                if (!m.getName().equals(calledMethod) || !m.getSignature().equals(calledSignature)) continue;
                return m;
            }
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(Map<String, Set<String>> validMethods, String clsName) throws IOException, ClassNotFoundException {
        InputStream is = null;
        try {
            Set<String> methodInfos = validMethods.get(clsName);
            if (methodInfos == null) {
                ZipEntry ze = this.jdkZip.getEntry(clsName + ".class");
                if (ze != null) {
                    is = new BufferedInputStream(this.jdkZip.getInputStream(ze));
                    ClassParser parser = new ClassParser(is, clsName);
                    JavaClass calledClass = parser.parse();
                    this.superNames.put(clsName, calledClass.getSuperclassName().replace('.', '/'));
                    Method[] methods = calledClass.getMethods();
                    methodInfos = new HashSet<String>(methods.length);
                    validMethods.put(clsName, methodInfos);
                    for (Method m : methods) {
                        methodInfos.add(m.getName() + m.getSignature());
                    }
                } else if (clsName.startsWith("java/")) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SJVU_SUSPICIOUS_JDK_VERSION_USE.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addClass(clsName));
                }
            }
            if (methodInfos != null) {
                String wantedMethod = this.getNameConstantOperand() + this.getSigConstantOperand();
                if (methodInfos.contains(wantedMethod)) {
                    boolean parser = true;
                    return parser;
                }
                if ("java/lang/Object".equals(clsName)) {
                    boolean parser = false;
                    return parser;
                }
                boolean parser = this.isValid(validMethods, this.superNames.get(clsName));
                return parser;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private File getRTJarFile() {
        File[] possibleJdks;
        Matcher m;
        URL jdkUrl;
        String versionStr = VER_REG_EX.get(this.clsMajorVersion);
        if (versionStr == null) {
            return null;
        }
        File rtPath = this.versionPaths.get(versionStr);
        if (rtPath != null) {
            return rtPath;
        }
        if (this.versionPaths.containsKey(versionStr)) {
            return null;
        }
        if (this.jdksRoot == null && (jdkUrl = SuspiciousJDKVersionUse.class.getResource("/java/lang/Object.class")) != null && (m = jarPattern.matcher(jdkUrl.toExternalForm())).find()) {
            String path = m.group(1);
            this.jdksRoot = new File(path);
            Pattern verPat = Pattern.compile(versionStr);
            m = verPat.matcher(this.jdksRoot.getName());
            while (this.jdksRoot.getParentFile() != null && !m.find()) {
                this.jdksRoot = this.jdksRoot.getParentFile();
                m = verPat.matcher(this.jdksRoot.getName());
            }
            if (this.jdksRoot.getParentFile() == null) {
                this.versionPaths.put(versionStr, null);
                return null;
            }
            try {
                String encoding = System.getProperty("file.encoding");
                this.jdksRoot = new File(URLDecoder.decode(this.jdksRoot.getParentFile().getPath(), encoding));
            }
            catch (UnsupportedEncodingException uee) {
                this.versionPaths.put(versionStr, null);
                return null;
            }
        }
        if (this.jdksRoot != null && (possibleJdks = this.jdksRoot.listFiles()) != null) {
            for (File possibleJdk : possibleJdks) {
                Pattern verPat = Pattern.compile(versionStr);
                Matcher m2 = verPat.matcher(possibleJdk.getName());
                if (!m2.find()) continue;
                File wantedRtJar = new File(possibleJdk, "lib/rt.jar");
                if (!wantedRtJar.exists() && !(wantedRtJar = new File(possibleJdk, "jre/lib/rt.jar")).exists()) {
                    this.versionPaths.put(versionStr, null);
                    return null;
                }
                this.versionPaths.put(versionStr, wantedRtJar);
                return wantedRtJar;
            }
        }
        this.versionPaths.put(versionStr, null);
        return null;
    }

    private static File getRTJarFromProperty(Integer requestedVersion) {
        String jdkHome = System.getProperty("fb-contrib.sjvu.jdkhome." + HUMAN_VERSIONS.get(requestedVersion));
        if (jdkHome == null) {
            return null;
        }
        File rtJar = new File(jdkHome, "lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        rtJar = new File(jdkHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        return null;
    }

    static {
        VER_REG_EX.put(45, "(jdk|j2?re)1.1");
        VER_REG_EX.put(46, "(jdk|j2?re)1.2");
        VER_REG_EX.put(47, "(jdk|j2?re)1.3");
        VER_REG_EX.put(48, "(jdk|j2?re)1.4");
        VER_REG_EX.put(49, "((jdk|j2?re)1.5)|(java-5)");
        VER_REG_EX.put(50, "((jdk|j2?re)1.6)|(java-6)");
        VER_REG_EX.put(51, "((jdk|j2?re)1.7)|(java-7)");
        VER_REG_EX.put(52, "((jdk|j2?re)1.8)|(java-8)");
        HUMAN_VERSIONS = new HashMap<Integer, Integer>();
        HUMAN_VERSIONS.put(45, Values.ONE);
        HUMAN_VERSIONS.put(46, Values.TWO);
        HUMAN_VERSIONS.put(47, Values.THREE);
        HUMAN_VERSIONS.put(48, Values.FOUR);
        HUMAN_VERSIONS.put(49, Values.FIVE);
        HUMAN_VERSIONS.put(50, Values.SIX);
        HUMAN_VERSIONS.put(51, Values.SEVEN);
        HUMAN_VERSIONS.put(52, Values.EIGHT);
        jarPattern = Pattern.compile("jar:file:/*([^!]*)");
    }
}

