/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class SuspiciousLoopSearch
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> storeRegs;
    private BitSet loadRegs;
    private State state;
    private int equalsPos;
    private int ifeqBranchTarget;

    public SuspiciousLoopSearch(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.storeRegs = new HashMap<Integer, Integer>();
            this.loadRegs = new BitSet();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.loadRegs = null;
            this.storeRegs = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.storeRegs.clear();
            this.loadRegs.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = State.SAW_NOTHING;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        try {
            switch (1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$SuspiciousLoopSearch$State[this.state.ordinal()]) {
                case 1: {
                    if (seen != 182) ** break;
                    methodName = this.getNameConstantOperand();
                    sig = this.getSigConstantOperand();
                    if ("equals".equals(methodName) && "(Ljava/lang/Object;)Z".equals(sig)) {
                        this.state = State.SAW_EQUALS;
                        this.equalsPos = this.getPC();
                        ** break;
                    }
lbl11:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (seen == 153) {
                        this.state = State.SAW_IFEQ;
                        this.ifeqBranchTarget = this.getBranchTarget();
                        ** break;
lbl17:
                        // 1 sources

                    } else {
                        this.state = State.SAW_NOTHING;
                        ** break;
                    }
lbl20:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    if (this.getPC() >= this.ifeqBranchTarget) {
                        if (seen == 167 && !this.storeRegs.isEmpty() && this.getBranchTarget() < this.equalsPos) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.SLS_SUSPICIOUS_LOOP_SEARCH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.storeRegs.values().iterator().next().intValue()));
                        }
                        this.storeRegs.clear();
                        this.loadRegs.clear();
                        this.state = State.SAW_NOTHING;
                        ** break;
lbl29:
                        // 1 sources

                    } else if (OpcodeUtils.isBranch(seen) || OpcodeUtils.isReturn(seen)) {
                        this.state = State.SAW_NOTHING;
                        ** break;
lbl33:
                        // 1 sources

                    } else {
                        if (OpcodeUtils.isStore(seen)) {
                            reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
                            if (!this.loadRegs.get(reg)) {
                                lvt = this.getMethod().getLocalVariableTable();
                                sig = "";
                                if (lvt != null && (lv = lvt.getLocalVariable(reg, this.getPC())) != null) {
                                    sig = lv.getSignature();
                                }
                                if (!"Z".equals(sig)) {
                                    this.storeRegs.put(RegisterUtils.getStoreReg((DismantleBytecode)this, seen), this.getPC());
                                }
                            }
                        } else if (OpcodeUtils.isLoad(seen)) {
                            reg = RegisterUtils.getLoadReg((DismantleBytecode)this, seen);
                            this.storeRegs.remove(reg);
                            this.loadRegs.set(reg);
                        }
                        this.state = State.SAW_ASSIGNMENT;
                    }
                    break;
                }
                ** default:
lbl53:
                // 1 sources

                break;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(167);
    }

    static enum State {
        SAW_NOTHING,
        SAW_EQUALS,
        SAW_IFEQ,
        SAW_ASSIGNMENT;

    }
}

