/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class TristateBooleanPattern
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private boolean methodReported;

    public TristateBooleanPattern(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        Type retType = m.getReturnType();
        if ("Ljava/lang/Boolean;".equals(retType.getSignature())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.methodReported = false;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item item;
            if (this.methodReported) {
                return;
            }
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 176 && this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).isNull()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.TBP_TRISTATE_BOOLEAN_PATTERN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.methodReported = true;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

