/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.AttributesUtils;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;

@OpcodeStack.CustomUserValue
public class UnnecessaryNewNullCheck
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private BitSet allocationRegs;
    private Set<Integer> transitionPoints;

    public UnnecessaryNewNullCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.allocationRegs = new BitSet();
            this.transitionPoints = new HashSet<Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.allocationRegs = null;
            this.transitionPoints = null;
        }
    }

    public void visitCode(Code obj) {
        if (this.prescreen()) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.allocationRegs.clear();
            this.transitionPoints.clear();
            CodeException[] ce = obj.getExceptionTable();
            if (ce != null) {
                for (CodeException element : ce) {
                    this.transitionPoints.add(element.getEndPC());
                }
            }
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        sawAlloc = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (this.transitionPoints.contains(this.getPC())) {
                this.allocationRegs.clear();
                depth = this.stack.getStackDepth();
                for (i = 0; i < depth; ++i) {
                    item = this.stack.getStackItem(i);
                    item.setUserValue(null);
                }
            }
            switch (seen) {
                case 187: 
                case 189: 
                case 197: {
                    sawAlloc = true;
                    ** break;
                }
                case 183: {
                    if (!"<init>".equals(this.getNameConstantOperand())) ** break;
                    sawAlloc = true;
                    ** break;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) ** break;
                    item = this.stack.getStackItem(0);
                    reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (item.getUserValue() != null) {
                        this.allocationRegs.set(reg);
                        ** break;
                    }
                    this.allocationRegs.clear(reg);
                    ** break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    sawAlloc = this.allocationRegs.get(reg);
                    ** break;
                }
                case 198: 
                case 199: {
                    if (this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getUserValue() != null && AttributesUtils.isValidLineNumber(this.getCode(), this.getPC())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UNNC_UNNECESSARY_NEW_NULL_CHECK.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.transitionPoints.add(this.getBranchTarget());
                    this.allocationRegs.clear();
                    ** break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 200: {
                    this.transitionPoints.add(this.getBranchTarget());
                    this.allocationRegs.clear();
                    ** break;
                }
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.allocationRegs.clear();
                    ** break;
                }
            }
        }
        catch (Throwable var6_9) {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue((Object)(sawAlloc != false ? Boolean.TRUE : null));
            }
            throw var6_9;
        }
lbl55:
        // 11 sources

        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (this.stack.getStackDepth() > 0) {
            item = this.stack.getStackItem(0);
            item.setUserValue((Object)(sawAlloc != false ? Boolean.TRUE : null));
        }
    }

    private boolean prescreen() {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(this.getMethod());
        return bytecodeSet != null && (bytecodeSet.get(187) || bytecodeSet.get(189) || bytecodeSet.get(197));
    }
}

