/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class UnusedParameter
extends BytecodeScanningDetector {
    private static Set<String> IGNORE_METHODS = new HashSet<String>();
    private BugReporter bugReporter;
    private BitSet unusedParms;
    private Map<Integer, Integer> regToParm;
    private OpcodeStack stack;

    public UnusedParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.unusedParms = new BitSet();
            this.regToParm = new HashMap<Integer, Integer>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.regToParm = null;
            this.unusedParms.clear();
        }
    }

    public void visitCode(Code obj) {
        Type[] parmTypes;
        this.unusedParms.clear();
        this.regToParm.clear();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        Method m = this.getMethod();
        String methodName = m.getName();
        if (IGNORE_METHODS.contains(methodName)) {
            return;
        }
        int accessFlags = m.getAccessFlags();
        if ((accessFlags & 0xA) != 0 && (accessFlags & 0x1000) == 0 && (parmTypes = Type.getArgumentTypes((String)m.getSignature())).length > 0) {
            int firstReg = 0;
            if ((accessFlags & 8) == 0) {
                ++firstReg;
            }
            int reg = firstReg;
            for (int i = 0; i < parmTypes.length; ++i) {
                this.unusedParms.set(reg);
                this.regToParm.put(reg, i + 1);
                String parmSig = parmTypes[i].getSignature();
                reg += "J".equals(parmSig) || "D".equals(parmSig) ? 2 : 1;
            }
            super.visitCode(obj);
            if (!this.unusedParms.isEmpty()) {
                LocalVariableTable lvt = m.getLocalVariableTable();
                reg = this.unusedParms.nextSetBit(firstReg);
                while (reg >= 0) {
                    LocalVariable lv;
                    LocalVariable localVariable = lv = lvt != null ? lvt.getLocalVariable(reg, 0) : null;
                    if (lv != null) {
                        String parmName = lv.getName();
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UP_UNUSED_PARAMETER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString("Parameter " + this.regToParm.get(reg) + ": " + parmName));
                    }
                    reg = this.unusedParms.nextSetBit(reg + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        if (this.unusedParms.isEmpty()) {
            return;
        }
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int reg = this.getRegisterOperand();
                    this.unusedParms.clear(reg);
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    if (reg < 0) return;
                    this.unusedParms.clear(reg);
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    static {
        IGNORE_METHODS.add("<init>");
        IGNORE_METHODS.add("<clinit>");
        IGNORE_METHODS.add("main");
        IGNORE_METHODS.add("premain");
        IGNORE_METHODS.add("agentmain");
        IGNORE_METHODS.add("writeObject");
        IGNORE_METHODS.add("readObject");
        IGNORE_METHODS.add("readObjectNoData");
        IGNORE_METHODS.add("writeReplace");
        IGNORE_METHODS.add("readResolve");
        IGNORE_METHODS.add("writeExternal");
        IGNORE_METHODS.add("readExternal");
    }
}

