/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

@OpcodeStack.CustomUserValue
public class UseAddAll
extends BytecodeScanningDetector {
    private JavaClass collectionClass;
    private ClassNotFoundException ex;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Comparable<?>, Comparable<?>> userValues;
    private Map<Comparable<?>, LoopInfo> loops;
    private boolean isInstanceMethod;

    public UseAddAll(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.collectionClass = Repository.lookupClass((String)"java/util/Collection");
        }
        catch (ClassNotFoundException cnfe) {
            this.collectionClass = null;
            this.ex = cnfe;
        }
    }

    public void visitClassContext(ClassContext classContext) {
        if (this.collectionClass == null) {
            if (this.ex != null) {
                this.bugReporter.reportMissingClass(this.ex);
                this.ex = null;
            }
            return;
        }
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        try {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.userValues = new HashMap();
            this.loops = new HashMap();
            this.isInstanceMethod = !this.getMethod().isStatic();
            super.visitCode(obj);
        }
        finally {
            this.userValues = null;
            this.loops = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block63: {
            Comparable uValue;
            Object regOrField = null;
            boolean sawAlias = false;
            boolean sawLoad = false;
            try {
                OpcodeStack.Item itm;
                OpcodeStack.Item item;
                this.stack.precomputation((DismantleBytecode)this);
                int pc = this.getPC();
                Iterator<LoopInfo> it = this.loops.values().iterator();
                while (it.hasNext()) {
                    LoopInfo loop = it.next();
                    if (loop.getEndPC() - 3 <= pc) {
                        int loopPC = loop.getAddPC();
                        if (loopPC > 0) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UAA_USE_ADD_ALL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, loopPC));
                        }
                        it.remove();
                        continue;
                    }
                    if (loop.getEndPC() <= pc || loop.addPC >= pc - 5 || loop.addPC <= 0) continue;
                    it.remove();
                }
                if (seen == 185) {
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    if ("get".equals(methodName) && "(I)Ljava/lang/Object;".equals(signature)) {
                        if (this.stack.getStackDepth() > 1) {
                            OpcodeStack.Item itm2 = this.stack.getStackItem(1);
                            int reg = this.isLocalCollection(itm2);
                            if (reg >= 0) {
                                regOrField = reg;
                                sawAlias = true;
                            } else {
                                String field = this.isFieldCollection(itm2);
                                if (field != null) {
                                    regOrField = field;
                                    sawAlias = true;
                                }
                            }
                        }
                    } else if ("keySet".equals(methodName) || "values".equals(methodName) || "iterator".equals(methodName) || "next".equals(methodName) || "hasNext".equals(methodName)) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item itm3 = this.stack.getStackItem(0);
                            int reg = this.isLocalCollection(itm3);
                            if (reg >= 0) {
                                regOrField = reg;
                                sawAlias = true;
                            } else {
                                String field = this.isFieldCollection(itm3);
                                if (field != null) {
                                    regOrField = field;
                                    sawAlias = true;
                                }
                            }
                        }
                    } else if ("add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(signature) && this.stack.getStackDepth() > 1) {
                        OpcodeStack.Item colItem = this.stack.getStackItem(1);
                        OpcodeStack.Item valueItem = this.stack.getStackItem(0);
                        int reg = this.isLocalCollection(colItem);
                        if (reg >= 0) {
                            LoopInfo loop;
                            regOrField = reg;
                            uValue = (Comparable)valueItem.getUserValue();
                            if (uValue != null && (loop = this.loops.get(uValue)) != null && loop.isInLoop(pc) && this.getCodeByte(this.getNextPC()) == 87) {
                                loop.foundAdd(pc);
                            }
                        } else {
                            String field = this.isFieldCollection(colItem);
                            if (field != null) {
                                LoopInfo loop;
                                regOrField = field;
                                uValue = (Comparable)valueItem.getUserValue();
                                if (uValue != null && (loop = this.loops.get(uValue)) != null && loop.isInLoop(pc) && this.getCodeByte(this.getNextPC()) == 87) {
                                    loop.foundAdd(pc);
                                }
                            }
                        }
                    }
                } else if (seen == 54 || seen >= 59 && seen <= 62 || seen == 58 || seen >= 75 && seen <= 78) {
                    if (this.stack.getStackDepth() > 0) {
                        uValue = (Comparable)this.stack.getStackItem(0).getUserValue();
                        this.userValues.put(Integer.valueOf(RegisterUtils.getStoreReg((DismantleBytecode)this, seen)), uValue);
                    }
                } else if (seen == 21 || seen >= 26 && seen <= 29 || seen == 25 || seen >= 42 && seen <= 45) {
                    sawLoad = true;
                } else if (seen == 153) {
                    boolean loopFound = false;
                    if (this.stack.getStackDepth() > 0 && this.getBranchOffset() > 0) {
                        int gotoPos = this.getBranchTarget() - 3;
                        byte[] code = this.getCode().getCode();
                        if ((0xFF & code[gotoPos]) == 167) {
                            short brOffset = (short)(0xFF & code[gotoPos + 1]);
                            brOffset = (short)(brOffset << 8);
                            if ((gotoPos += (brOffset = (short)(brOffset | 0xFF & code[gotoPos + 2]))) < pc) {
                                OpcodeStack.Item itm4 = this.stack.getStackItem(0);
                                uValue = (Comparable)itm4.getUserValue();
                                if (uValue != null) {
                                    this.loops.put(uValue, new LoopInfo(pc, this.getBranchTarget()));
                                }
                                loopFound = true;
                            }
                        }
                        if (!loopFound) {
                            this.removeLoop(pc);
                        }
                    }
                } else if (this.isInstanceMethod && seen == 181) {
                    if (this.stack.getStackDepth() > 1 && (item = this.stack.getStackItem(1)).getRegisterNumber() == 0) {
                        uValue = (Comparable)this.stack.getStackItem(0).getUserValue();
                        this.userValues.put((Comparable<?>)((Object)this.getNameConstantOperand()), uValue);
                    }
                } else if (this.isInstanceMethod && seen == 180) {
                    if (this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getRegisterNumber() == 0) {
                        sawLoad = true;
                    }
                } else if (seen > 153 && seen <= 167 || seen == 198 || seen == 199) {
                    this.removeLoop(pc);
                } else if (seen == 192 && this.stack.getStackDepth() > 0 && (uValue = (Comparable)(itm = this.stack.getStackItem(0)).getUserValue()) != null) {
                    regOrField = uValue;
                    sawAlias = true;
                }
                TernaryPatcher.pre(this.stack, seen);
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
                break block63;
            }
            finally {
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (sawAlias) {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        itm.setUserValue(regOrField);
                    }
                } else if (sawLoad && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    int reg = itm.getRegisterNumber();
                    if (reg >= 0) {
                        Comparable<?> uValue2 = this.userValues.get(reg);
                        itm.setUserValue(uValue2);
                    } else {
                        XField xField = itm.getXField();
                        if (xField != null) {
                            Comparable<?> uValue3 = this.userValues.get(xField.getName());
                            itm.setUserValue(uValue3);
                        }
                    }
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawAlias) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    itm.setUserValue(regOrField);
                }
            } else if (sawLoad && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                int reg = itm.getRegisterNumber();
                if (reg >= 0) {
                    uValue = this.userValues.get(reg);
                    itm.setUserValue(uValue);
                } else {
                    XField xField = itm.getXField();
                    if (xField != null) {
                        uValue = this.userValues.get(xField.getName());
                        itm.setUserValue((Object)uValue);
                    }
                }
            }
        }
    }

    private int isLocalCollection(OpcodeStack.Item item) throws ClassNotFoundException {
        Comparable aliasReg = (Comparable)item.getUserValue();
        if (aliasReg instanceof Integer) {
            return (Integer)aliasReg;
        }
        int reg = item.getRegisterNumber();
        if (reg < 0) {
            return -1;
        }
        JavaClass cls = item.getJavaClass();
        if (cls != null && cls.implementationOf(this.collectionClass)) {
            return reg;
        }
        return -1;
    }

    private String isFieldCollection(OpcodeStack.Item item) throws ClassNotFoundException {
        Comparable aliasReg = (Comparable)item.getUserValue();
        if (aliasReg instanceof String) {
            return (String)((Object)aliasReg);
        }
        XField field = item.getXField();
        if (field == null) {
            return null;
        }
        JavaClass cls = item.getJavaClass();
        if (cls != null && cls.implementationOf(this.collectionClass)) {
            return field.getName();
        }
        return null;
    }

    private void removeLoop(int pc) {
        Iterator<LoopInfo> it = this.loops.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isInLoop(pc)) continue;
            it.remove();
        }
    }

    static class LoopInfo {
        private final int start;
        private final int end;
        private int addPC;

        LoopInfo(int loopStart, int loopEnd) {
            this.start = loopStart;
            this.end = loopEnd;
            this.addPC = 0;
        }

        boolean isInLoop(int pc) {
            return pc >= this.start && pc <= this.end;
        }

        void foundAdd(int pc) {
            this.addPC = this.addPC == 0 ? pc : -1;
        }

        int getStartPC() {
            return this.start;
        }

        int getEndPC() {
            return this.end;
        }

        int getAddPC() {
            return this.addPC;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

