/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class UseCharacterParameterizedMethod
extends BytecodeScanningDetector {
    private static final Map<String, Object> characterMethods;
    private final BugReporter bugReporter;
    private OpcodeStack stack;

    public UseCharacterParameterizedMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext context) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(context);
        }
        finally {
            this.stack = null;
        }
    }

    private boolean prescreen(Method obj) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(obj);
        return bytecodeSet != null && (bytecodeSet.get(18) || bytecodeSet.get(19));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 || seen == 185) {
                String key = this.getClassConstantOperand() + ':' + this.getNameConstantOperand() + ':' + this.getSigConstantOperand();
                Object posObject = characterMethods.get(key);
                if (posObject instanceof Integer) {
                    if (this.checkSingleParamMethod((Integer)posObject)) {
                        this.reportBug();
                    }
                } else if (posObject instanceof IntPair && this.checkDoubleParamMethod((IntPair)posObject)) {
                    this.reportBug();
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private void reportBug() {
        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.UCPM_USE_CHARACTER_PARAMETERIZED_METHOD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
    }

    private boolean checkDoubleParamMethod(IntPair posObject) {
        return this.checkSingleParamMethod(posObject.firstStringParam) && this.checkSingleParamMethod(posObject.secondStringParam);
    }

    private boolean checkSingleParamMethod(Integer paramPos) {
        OpcodeStack.Item itm;
        CharSequence con;
        int stackPos = paramPos;
        return this.stack.getStackDepth() > stackPos && (con = (CharSequence)(itm = this.stack.getStackItem(stackPos)).getConstant()) != null && con.length() == 1;
    }

    static {
        HashMap<String, Object> methodsMap = new HashMap<String, Object>();
        methodsMap.put("java/lang/String:indexOf:(Ljava/lang/String;)I", Values.ZERO);
        methodsMap.put("java/lang/String:indexOf:(Ljava/lang/String;I)I", Values.ONE);
        methodsMap.put("java/lang/String:lastIndexOf:(Ljava/lang/String;)I", Values.ZERO);
        methodsMap.put("java/lang/String:lastIndexOf:(Ljava/lang/String;I)I", Values.ONE);
        methodsMap.put("java/io/PrintStream:print:(Ljava/lang/String;)V", Values.ZERO);
        methodsMap.put("java/io/PrintStream:println:(Ljava/lang/String;)V", Values.ZERO);
        methodsMap.put("java/io/StringWriter:write:(Ljava/lang/String;)V", Values.ZERO);
        methodsMap.put("java/lang/StringBuffer:append:(Ljava/lang/String;)Ljava/lang/StringBuffer;", Values.ZERO);
        methodsMap.put("java/lang/StringBuilder:append:(Ljava/lang/String;)Ljava/lang/StringBuilder;", Values.ZERO);
        methodsMap.put("java/lang/String:replace:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", new IntPair(0, 1));
        characterMethods = Collections.unmodifiableMap(methodsMap);
    }

    private static class IntPair {
        final int firstStringParam;
        final int secondStringParam;

        IntPair(int firstStringParam, int secondStringParam) {
            this.firstStringParam = firstStringParam;
            this.secondStringParam = secondStringParam;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

