/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

@OpcodeStack.CustomUserValue
public class UseSplit
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, State> regValueType;
    private State state;
    private int loopStart;
    private int loopEnd;

    public UseSplit(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.getMajor() >= 48) {
                this.stack = new OpcodeStack();
                this.regValueType = new HashMap<Integer, State>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
            this.regValueType = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.regValueType.clear();
        this.state = State.SEEN_NOTHING;
        this.loopStart = -1;
        this.loopEnd = -1;
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            int pc = this.getPC();
            if (this.loopEnd != -1 && pc > this.loopEnd) {
                this.loopStart = -1;
                this.loopEnd = -1;
                this.regValueType.clear();
            }
            if (seen == 25 || seen >= 42 && seen <= 45) {
                int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                State type = this.regValueType.get(reg);
                if (type != null) {
                    this.state = type;
                    return;
                }
                this.state = State.SEEN_NOTHING;
                return;
            }
            if (seen == 58 || seen >= 75 && seen <= 78) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    this.regValueType.put(reg, (State)((Object)item.getUserValue()));
                }
                this.state = State.SEEN_NOTHING;
                return;
            }
            if (seen == 21 || seen >= 26 && seen <= 29) {
                int reg = RegisterUtils.getLoadReg((DismantleBytecode)this, seen);
                State type = this.regValueType.get(reg);
                if (type != null) {
                    this.state = type;
                    return;
                }
                this.state = State.SEEN_NOTHING;
                return;
            }
            if (seen == 54 || seen >= 59 && seen <= 62) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
                    this.regValueType.put(reg, (State)((Object)item.getUserValue()));
                }
                this.state = State.SEEN_NOTHING;
                return;
            }
            switch (this.state) {
                case SEEN_NOTHING: {
                    if (seen != 183) return;
                    if (!"java/util/StringTokenizer".equals(this.getClassConstantOperand())) return;
                    if (!"<init>".equals(this.getNameConstantOperand())) return;
                    if (!"(Ljava/lang/String;Ljava/lang/String;)V".equals(this.getSigConstantOperand())) return;
                    this.state = State.SEEN_STRINGTOKENIZER;
                    return;
                }
                case SEEN_STRINGTOKENIZER: {
                    if (seen != 182) return;
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    if ("countTokens".equals(methodName) && "()I".equals(signature)) {
                        this.state = State.SEEN_COUNTTOKENS;
                        return;
                    }
                    if ("hasMoreTokens".equals(methodName) || "hasMoreElements".equals(methodName)) {
                        this.state = State.SEEN_HASMORE;
                        return;
                    }
                    if (!"nextToken".equals(methodName)) {
                        if (!"nextElement".equals(methodName)) return;
                    }
                    if (pc >= this.loopStart && pc <= this.loopEnd) {
                        this.state = State.SEEN_NEXT;
                        return;
                    }
                    this.regValueType.clear();
                    return;
                }
                case SEEN_COUNTTOKENS: {
                    if (seen == 189) {
                        this.state = State.SEEN_NEWARRAY;
                        return;
                    }
                    if (seen != 162) return;
                    int target = this.getBranchTarget() - 3;
                    byte[] code = this.getCode().getCode();
                    if ((code[target] & 0xFF) != 167) return;
                    int offset = (code[target + 1] << 1) + code[target + 2];
                    int gotoTarget = target + offset + 3;
                    if (gotoTarget >= this.getPC()) return;
                    this.loopStart = gotoTarget;
                    this.loopEnd = target;
                    return;
                }
                case SEEN_HASMORE: {
                    if (seen == 153) {
                        int offset;
                        int gotoTarget;
                        int target = this.getBranchTarget() - 3;
                        byte[] code = this.getCode().getCode();
                        if ((code[target] & 0xFF) == 167 && (gotoTarget = target + (offset = (code[target + 1] << 1) + code[target + 2]) + 3) < this.getPC()) {
                            this.loopStart = gotoTarget;
                            this.loopEnd = target;
                        }
                    }
                    this.state = State.SEEN_NOTHING;
                    return;
                }
                case SEEN_NEXT: {
                    if (seen == 83 && pc > this.loopStart && pc < this.loopEnd && this.stack.getStackDepth() > 2) {
                        OpcodeStack.Item arrayItem = this.stack.getStackItem(2);
                        State arrayType = (State)((Object)arrayItem.getUserValue());
                        OpcodeStack.Item elemItem = this.stack.getStackItem(0);
                        State elemType = (State)((Object)elemItem.getUserValue());
                        if (arrayType == State.SEEN_NEWARRAY && elemType == State.SEEN_NEXT) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.USS_USE_STRING_SPLIT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    this.state = State.SEEN_NOTHING;
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.state != State.SEEN_NOTHING && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)this.state);
            }
        }
    }

    static enum State {
        SEEN_NOTHING,
        SEEN_STRINGTOKENIZER,
        SEEN_COUNTTOKENS,
        SEEN_NEWARRAY,
        SEEN_HASMORE,
        SEEN_NEXT,
        SEEN_ARRAYSTORE;

    }
}

