/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.MissingMethodsDetector;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class WriteOnlyCollection
extends MissingMethodsDetector {
    private static Set<String> collectionClasses = new HashSet<String>();
    private static Set<String> nonInformationalMethods;
    private int firstLocalRegister;

    public WriteOnlyCollection(BugReporter bugReporter) {
        super(bugReporter);
    }

    public void visitMethod(Method obj) {
        this.firstLocalRegister = SignatureUtils.getFirstRegisterSlot(obj);
        super.visitMethod(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        int reg;
        OpcodeStack stack;
        if (seen == 181 && (stack = this.getStack()).getStackDepth() > 0 && (reg = (item = stack.getStackItem(0)).getRegisterNumber()) >= 0 && reg < this.firstLocalRegister) {
            this.clearSpecialField(this.getNameConstantOperand());
        }
        super.sawOpcode(seen);
    }

    @Override
    protected BugInstance makeFieldBugInstance() {
        return new BugInstance((Detector)this, BugType.WOC_WRITE_ONLY_COLLECTION_FIELD.name(), 2);
    }

    @Override
    protected BugInstance makeLocalBugInstance() {
        return new BugInstance((Detector)this, BugType.WOC_WRITE_ONLY_COLLECTION_LOCAL.name(), 2);
    }

    @Override
    protected boolean doesObjectNeedToBeWatched(String type) {
        return collectionClasses.contains(type);
    }

    @Override
    protected boolean isMethodThatShouldBeCalled(String methodName) {
        return !nonInformationalMethods.contains(methodName);
    }

    static {
        collectionClasses.add(Set.class.getName());
        collectionClasses.add(Map.class.getName());
        collectionClasses.add(List.class.getName());
        collectionClasses.add(SortedSet.class.getName());
        collectionClasses.add(SortedMap.class.getName());
        collectionClasses.add(Collection.class.getName());
        collectionClasses.add(EnumSet.class.getName());
        collectionClasses.add(EnumMap.class.getName());
        collectionClasses.add(HashSet.class.getName());
        collectionClasses.add(IdentityHashMap.class.getName());
        collectionClasses.add(TreeSet.class.getName());
        collectionClasses.add(LinkedHashSet.class.getName());
        collectionClasses.add(HashMap.class.getName());
        collectionClasses.add(TreeMap.class.getName());
        collectionClasses.add(Hashtable.class.getName());
        collectionClasses.add(LinkedHashMap.class.getName());
        collectionClasses.add(Vector.class.getName());
        collectionClasses.add(ArrayList.class.getName());
        collectionClasses.add(LinkedList.class.getName());
        collectionClasses.add(Deque.class.getName());
        collectionClasses.add(Queue.class.getName());
        collectionClasses.add(ArrayDeque.class.getName());
        collectionClasses.add(LinkedBlockingDeque.class.getName());
        collectionClasses.add(NavigableMap.class.getName());
        collectionClasses.add(ConcurrentLinkedQueue.class.getName());
        collectionClasses.add(ConcurrentMap.class.getName());
        collectionClasses.add(ConcurrentNavigableMap.class.getName());
        collectionClasses.add(ConcurrentSkipListMap.class.getName());
        collectionClasses.add(ConcurrentHashMap.class.getName());
        collectionClasses.add(ConcurrentSkipListSet.class.getName());
        collectionClasses.add(CopyOnWriteArrayList.class.getName());
        nonInformationalMethods = new HashSet<String>();
        nonInformationalMethods.add("add");
        nonInformationalMethods.add("addAll");
        nonInformationalMethods.add("addElement");
        nonInformationalMethods.add("addFirst");
        nonInformationalMethods.add("addLast");
        nonInformationalMethods.add("clear");
        nonInformationalMethods.add("ensureCapacity");
        nonInformationalMethods.add("insertElementAt");
        nonInformationalMethods.add("push");
        nonInformationalMethods.add("put");
        nonInformationalMethods.add("putAll");
        nonInformationalMethods.add("remove");
        nonInformationalMethods.add("removeAll");
        nonInformationalMethods.add("removeElement");
        nonInformationalMethods.add("removeElementAt");
        nonInformationalMethods.add("removeRange");
        nonInformationalMethods.add("set");
        nonInformationalMethods.add("setElementAt");
        nonInformationalMethods.add("setSize");
        nonInformationalMethods.add("trimToSize");
    }
}

