/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import java.util.BitSet;
import org.apache.bcel.Constants;

public class OpcodeUtils
implements Constants {
    private static final BitSet BRANCH_OPS = new BitSet();

    private OpcodeUtils() {
    }

    public static boolean isALoad(int seen) {
        return seen == 25 || seen >= 42 && seen <= 45;
    }

    public static boolean isAStore(int seen) {
        return seen == 58 || seen >= 75 && seen <= 78;
    }

    public static boolean isILoad(int seen) {
        return seen == 21 || seen >= 26 && seen <= 29;
    }

    public static boolean isIStore(int seen) {
        return seen == 54 || seen >= 59 && seen <= 62;
    }

    public static boolean isLLoad(int seen) {
        return seen == 22 || seen >= 30 && seen <= 33;
    }

    public static boolean isLStore(int seen) {
        return seen == 55 || seen >= 63 && seen <= 66;
    }

    public static boolean isFLoad(int seen) {
        return seen == 23 || seen >= 34 && seen <= 37;
    }

    public static boolean isFStore(int seen) {
        return seen == 56 || seen >= 67 && seen <= 70;
    }

    public static boolean isDLoad(int seen) {
        return seen == 24 || seen >= 38 && seen <= 41;
    }

    public static boolean isDStore(int seen) {
        return seen == 57 || seen >= 71 && seen <= 74;
    }

    public static boolean isLoad(int seen) {
        return OpcodeUtils.isALoad(seen) || OpcodeUtils.isILoad(seen) || OpcodeUtils.isLLoad(seen) || OpcodeUtils.isFLoad(seen) || OpcodeUtils.isDLoad(seen);
    }

    public static boolean isStore(int seen) {
        return OpcodeUtils.isAStore(seen) || OpcodeUtils.isIStore(seen) || OpcodeUtils.isLStore(seen) || OpcodeUtils.isFStore(seen) || OpcodeUtils.isDStore(seen);
    }

    public static boolean isInvokeInterfaceSpecialStaticOrVirtual(int seen) {
        return seen == 183 || seen == 185 || seen == 182 || seen == 184;
    }

    public static boolean isBranch(int seen) {
        return BRANCH_OPS.get(seen);
    }

    public static boolean isReturn(int seen) {
        return seen == 176 || seen == 172 || seen == 173 || seen == 174 || seen == 175;
    }

    static {
        BRANCH_OPS.set(167);
        BRANCH_OPS.set(200);
        BRANCH_OPS.set(165);
        BRANCH_OPS.set(166);
        BRANCH_OPS.set(159);
        BRANCH_OPS.set(162);
        BRANCH_OPS.set(163);
        BRANCH_OPS.set(164);
        BRANCH_OPS.set(161);
        BRANCH_OPS.set(160);
        BRANCH_OPS.set(153);
        BRANCH_OPS.set(156);
        BRANCH_OPS.set(157);
        BRANCH_OPS.set(158);
        BRANCH_OPS.set(155);
        BRANCH_OPS.set(154);
        BRANCH_OPS.set(199);
        BRANCH_OPS.set(198);
    }
}

