/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class RegisterUtils {
    private RegisterUtils() {
    }

    public static int getAStoreReg(DismantleBytecode dbc, int seen) {
        if (seen == 58) {
            return dbc.getRegisterOperand();
        }
        if (seen >= 75 && seen <= 78) {
            return seen - 75;
        }
        return -1;
    }

    public static int getALoadReg(DismantleBytecode dbc, int seen) {
        if (seen == 25) {
            return dbc.getRegisterOperand();
        }
        if (seen >= 42 && seen <= 45) {
            return seen - 42;
        }
        return -1;
    }

    public static int getStoreReg(DismantleBytecode dbc, int seen) {
        if (seen == 58 || seen == 54 || seen == 55 || seen == 56 || seen == 57) {
            return dbc.getRegisterOperand();
        }
        if (seen >= 59 && seen <= 62) {
            return seen - 59;
        }
        if (seen <= 66) {
            return seen - 63;
        }
        if (seen <= 70) {
            return seen - 67;
        }
        if (seen <= 74) {
            return seen - 71;
        }
        if (seen <= 78) {
            return seen - 75;
        }
        return -1;
    }

    public static int getLoadReg(DismantleBytecode dbc, int seen) {
        if (seen == 25 || seen == 21 || seen == 22 || seen == 23 || seen == 24) {
            return dbc.getRegisterOperand();
        }
        if (seen >= 26 && seen <= 29) {
            return seen - 26;
        }
        if (seen <= 33) {
            return seen - 30;
        }
        if (seen <= 37) {
            return seen - 34;
        }
        if (seen <= 41) {
            return seen - 38;
        }
        if (seen <= 45) {
            return seen - 42;
        }
        return -1;
    }

    public static int getLocalVariableEndRange(LocalVariableTable lvt, int reg, int curPC) {
        LocalVariable lv;
        int endRange = Integer.MAX_VALUE;
        if (lvt != null && (lv = lvt.getLocalVariable(reg, curPC)) != null) {
            endRange = lv.getStartPC() + lv.getLength();
        }
        return endRange;
    }

    public static int[] getParameterRegisters(Method obj) {
        Type[] argTypes = obj.getArgumentTypes();
        int[] regs = new int[argTypes.length];
        int curReg = obj.isStatic() ? 0 : 1;
        for (int t = 0; t < argTypes.length; ++t) {
            String sig = argTypes[t].getSignature();
            regs[t] = curReg;
            if ("J".equals(sig) || "D".equals(sig)) {
                ++curReg;
            }
            ++curReg;
        }
        return regs;
    }
}

