/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ToString {
    private static final ThreadLocal<VisitedInfo> visited = new ThreadLocal<VisitedInfo>(){

        @Override
        protected VisitedInfo initialValue() {
            return new VisitedInfo();
        }
    };

    private ToString() {
    }

    public static String build(Object o) {
        VisitedInfo vi = visited.get();
        try {
            ++vi.count;
            String string = ToString.generate(o, vi.visited);
            return string;
        }
        finally {
            if (--vi.count == 0) {
                vi.visited.clear();
            }
        }
    }

    private static String generate(Object o, Set<Integer> visitedObjects) {
        StringBuilder sb = new StringBuilder(100);
        Class<?> cls = o.getClass();
        Integer identityHC = System.identityHashCode(o);
        sb.append(cls.getSimpleName()).append('[').append(identityHC).append("]{");
        if (!visitedObjects.contains(identityHC)) {
            try {
                visitedObjects.add(identityHC);
                String sep = "";
                for (Field f : cls.getDeclaredFields()) {
                    if (f.isSynthetic() || f.getName().contains("$")) continue;
                    sb.append(sep);
                    sep = ", ";
                    sb.append(f.getName()).append('=');
                    try {
                        f.setAccessible(true);
                        Object value = f.get(o);
                        if (value == null) {
                            sb.append((String)null);
                            continue;
                        }
                        if (value.getClass().isArray()) {
                            sb.append(Arrays.toString((Object[])value));
                            continue;
                        }
                        sb.append(value);
                    }
                    catch (SecurityException e) {
                        sb.append("*SECURITY_EXCEPTION*");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private static class VisitedInfo {
        Set<Integer> visited = new HashSet<Integer>();
        int count = 0;

        private VisitedInfo() {
        }
    }
}

