/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import com.mebigfatguy.fbcontrib.collect.ImmutabilityType;
import com.mebigfatguy.fbcontrib.utils.ToString;

public class MethodInfo {
    public static final int PUBLIC_USE = 1;
    public static final int PRIVATE_USE = 2;
    public static final int PROTECTED_USE = 4;
    public static final int PACKAGE_USE = 8;
    private short numMethodBytes;
    private byte numMethodCalls;
    private byte immutabilityOrdinal;
    private byte declaredAccess;
    private byte isCalledType;

    public int getNumBytes() {
        return 0xFFFF & this.numMethodBytes;
    }

    public void setNumBytes(int numBytes) {
        this.numMethodBytes = (short)numBytes;
    }

    public int getNumMethodCalls() {
        return 0xFF & this.numMethodCalls;
    }

    public void setNumMethodCalls(int numCalls) {
        if (numCalls > 255) {
            numCalls = 255;
        }
        this.numMethodCalls = (byte)numCalls;
    }

    public void setDeclaredAccess(int access) {
        this.declaredAccess = (byte)access;
    }

    public int getDeclaredAccess() {
        return this.declaredAccess;
    }

    public void addCallingAccess(int access) {
        this.isCalledType = (access & 1) != 0 ? (byte)(this.isCalledType | 1) : ((access & 4) != 0 ? (byte)(this.isCalledType | 4) : ((access & 2) != 0 ? (byte)(this.isCalledType | 2) : (byte)(this.isCalledType | 8)));
    }

    public boolean wasCalled() {
        return (this.isCalledType & 0xF) != 0;
    }

    public boolean wasCalledPublicly() {
        return (this.isCalledType & 1) != 0;
    }

    public boolean wasCalledProtectedly() {
        return (this.isCalledType & 4) != 0;
    }

    public boolean wasCalledPackagely() {
        return (this.isCalledType & 8) != 0;
    }

    public boolean wasCalledPrivately() {
        return (this.isCalledType & 2) != 0;
    }

    public ImmutabilityType getImmutabilityType() {
        return ImmutabilityType.values()[this.immutabilityOrdinal];
    }

    public void setImmutabilityType(ImmutabilityType imType) {
        this.immutabilityOrdinal = (byte)imType.ordinal();
    }

    public String toString() {
        return ToString.build(this);
    }
}

