/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import com.mebigfatguy.fbcontrib.collect.ImmutabilityType;
import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.StatisticsKey;
import com.mebigfatguy.fbcontrib.utils.ToString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Statistics
implements Iterable<Map.Entry<StatisticsKey, MethodInfo>> {
    private static Statistics statistics = new Statistics();
    private static final MethodInfo NOT_FOUND_METHOD_INFO = new MethodInfo();
    private final Map<StatisticsKey, MethodInfo> methodStatistics = new HashMap<StatisticsKey, MethodInfo>();

    private Statistics() {
    }

    public static Statistics getStatistics() {
        return statistics;
    }

    public void clear() {
        this.methodStatistics.clear();
    }

    public MethodInfo addMethodStatistics(String className, String methodName, String signature, int access, int numBytes, int numMethodCalls) {
        StatisticsKey key = new StatisticsKey(className, methodName, signature);
        MethodInfo mi = this.methodStatistics.get(key);
        if (mi == null) {
            mi = new MethodInfo();
            this.methodStatistics.put(key, mi);
        }
        mi.setNumBytes(numBytes);
        mi.setNumMethodCalls(numMethodCalls);
        mi.setDeclaredAccess(access);
        return mi;
    }

    public MethodInfo getMethodStatistics(String className, String methodName, String signature) {
        MethodInfo mi = this.methodStatistics.get(new StatisticsKey(className, methodName, signature));
        if (mi == null) {
            return NOT_FOUND_METHOD_INFO;
        }
        return mi;
    }

    @Override
    public Iterator<Map.Entry<StatisticsKey, MethodInfo>> iterator() {
        return this.methodStatistics.entrySet().iterator();
    }

    public void addImmutabilityStatus(String className, String methodName, String signature, ImmutabilityType imType) {
        StatisticsKey key = new StatisticsKey(className, methodName, signature);
        MethodInfo mi = this.methodStatistics.get(key);
        if (mi == null) {
            mi = new MethodInfo();
            this.methodStatistics.put(key, mi);
        }
        mi.setImmutabilityType(imType);
    }

    public String toString() {
        return ToString.build(this);
    }
}

