/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.debug;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class OCSDebugger
extends BytecodeScanningDetector {
    private static final String OCS_OUTPUT_FILE = "fb-contrib.ocs.output";
    private static final String OCS_METHOD_DESC = "fb-contrib.ocs.method";
    private static final String OUTPUT_FILE_NAME = System.getProperty("fb-contrib.ocs.output");
    private static final String METHOD_DESC = System.getProperty("fb-contrib.ocs.method");
    private OpcodeStack stack = new OpcodeStack();
    private PrintWriter pw = null;

    public OCSDebugger(BugReporter bugReporter) {
    }

    public void visitClassContext(ClassContext classContext) {
        if (OUTPUT_FILE_NAME != null && METHOD_DESC != null) {
            super.visitClassContext(classContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        Method m = this.getMethod();
        String curMethodDesc = this.getClassContext().getJavaClass().getClassName() + '.' + m.getName() + m.getSignature();
        if (curMethodDesc.equals(METHOD_DESC)) {
            try {
                this.pw = new PrintWriter(OUTPUT_FILE_NAME, StandardCharsets.UTF_8.name());
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                super.visitCode(obj);
            }
            catch (IOException iOException) {
            }
            finally {
                this.pw.close();
                this.pw = null;
            }
        }
    }

    public void sawOpcode(int seen) {
        this.stack.precomputation((DismantleBytecode)this);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        this.pw.println(String.format("After executing: %-16s at PC: %-5d Stack Size: %-3d", Constants.OPCODE_NAMES[this.getOpcode()], this.getPC(), this.stack.getStackDepth()));
    }
}

