/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.QMethod;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class AbstractClassEmptyMethods
extends BytecodeScanningDetector {
    private static JavaClass EXCEPTION_CLASS;
    private final BugReporter bugReporter;
    private Set<QMethod> interfaceMethods;
    private String methodName;
    private State state;

    public AbstractClassEmptyMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (cls.isAbstract()) {
                this.interfaceMethods = this.collectInterfaceMethods(cls);
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.interfaceMethods = null;
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.state = State.SAW_NOTHING;
    }

    public void visitCode(Code obj) {
        if ("<init>".equals(this.methodName) || "<clinit>".equals(this.methodName)) {
            return;
        }
        if (!this.interfaceMethods.contains(new QMethod(this.methodName, this.getMethod().getSignature()))) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        try {
            switch (this.state) {
                case SAW_NOTHING: {
                    if (seen == 177) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ACEM_ABSTRACT_CLASS_EMPTY_METHODS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.state = State.SAW_DONE;
                        break;
                    }
                    if (seen == 187) {
                        String newClass = this.getClassConstantOperand();
                        JavaClass exCls = Repository.lookupClass((String)newClass);
                        if (EXCEPTION_CLASS != null && exCls.instanceOf(EXCEPTION_CLASS)) {
                            this.state = State.SAW_NEW;
                            break;
                        }
                        this.state = State.SAW_DONE;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_NEW: {
                    if (seen == 89) {
                        this.state = State.SAW_DUP;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_DUP: {
                    if ((seen == 18 || seen == 19) && this.getConstantRefOperand() instanceof ConstantString) {
                        this.state = State.SAW_LDC;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_LDC: {
                    if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
                        this.state = State.SAW_INVOKESPECIAL;
                        break;
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
                case SAW_INVOKESPECIAL: {
                    if (seen == 191) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ACEM_ABSTRACT_CLASS_EMPTY_METHODS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = State.SAW_DONE;
                    break;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            this.state = State.SAW_DONE;
        }
    }

    private Set<QMethod> collectInterfaceMethods(JavaClass cls) throws ClassNotFoundException {
        HashSet<QMethod> methods = new HashSet<QMethod>();
        for (JavaClass inf : cls.getAllInterfaces()) {
            for (Method m : inf.getMethods()) {
                methods.add(new QMethod(m.getName(), m.getSignature()));
            }
        }
        return methods;
    }

    static {
        try {
            EXCEPTION_CLASS = Repository.lookupClass((String)"java/lang/Exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    static enum State {
        SAW_NOTHING,
        SAW_NEW,
        SAW_DUP,
        SAW_LDC,
        SAW_INVOKESPECIAL,
        SAW_DONE;

    }
}

