/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class ArrayIndexOutOfBounds
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private BitSet initializedRegs;
    private BitSet modifyRegs;
    private Map<Integer, Integer> nullStoreToLocation;

    public ArrayIndexOutOfBounds(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.initializedRegs = new BitSet();
            this.modifyRegs = new BitSet();
            this.nullStoreToLocation = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.initializedRegs = null;
            this.modifyRegs = null;
            this.nullStoreToLocation = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.initializedRegs.clear();
        this.modifyRegs.clear();
        Type[] argTypes = m.getArgumentTypes();
        int arg = (m.getAccessFlags() & 8) != 0 ? 0 : 1;
        for (Type argType : argTypes) {
            String argSig = argType.getSignature();
            this.initializedRegs.set(arg);
            arg += SignatureUtils.getSignatureSize(argSig);
        }
        this.nullStoreToLocation.clear();
        super.visitCode(obj);
        for (Integer pc : this.nullStoreToLocation.values()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AIOB_ARRAY_STORE_TO_NULL_REFERENCE.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer size = null;
        boolean sizeSet = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    size = seen - 3;
                    sizeSet = true;
                    return;
                }
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    int reg = RegisterUtils.getLoadReg((DismantleBytecode)this, seen);
                    if (!this.modifyRegs.get(reg)) return;
                    this.modifyRegs.clear(reg);
                    sizeSet = true;
                    return;
                }
                case 16: 
                case 17: {
                    size = this.getIntConstant();
                    sizeSet = true;
                    return;
                }
                case 132: {
                    this.modifyRegs.set(this.getRegisterOperand());
                    return;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 136: 
                case 139: 
                case 142: {
                    sizeSet = true;
                    return;
                }
                case 54: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (item.getUserValue() != null) return;
                    this.modifyRegs.set(this.getRegisterOperand());
                    return;
                }
                case 18: {
                    Constant c = this.getConstantRefOperand();
                    if (!(c instanceof ConstantInteger)) return;
                    size = ((ConstantInteger)c).getBytes();
                    sizeSet = true;
                    return;
                }
                case 188: 
                case 189: {
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    size = (Integer)item.getUserValue();
                    sizeSet = true;
                    return;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.processArrayStore();
                    return;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.processArrayLoad();
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item value = this.stack.getStackItem(0);
                        if (value.isNull()) return;
                        this.initializedRegs.set(this.getRegisterOperand());
                        return;
                    }
                    this.initializedRegs.set(this.getRegisterOperand());
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 200: {
                    int branchTarget = this.getBranchTarget();
                    Iterator<Map.Entry<Integer, Integer>> it = this.nullStoreToLocation.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Integer, Integer> entry = it.next();
                        int pc = entry.getValue();
                        if (branchTarget >= pc || !this.initializedRegs.get(entry.getKey())) continue;
                        it.remove();
                    }
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (sizeSet && this.stack.getStackDepth() >= 1) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)size);
            }
        }
    }

    private void processArrayLoad() {
        OpcodeStack.Item arrayItem;
        Integer sz;
        OpcodeStack.Item indexItem;
        Integer index;
        if (this.stack.getStackDepth() >= 2 && (index = (Integer)(indexItem = this.stack.getStackItem(0)).getConstant()) != null && (sz = (Integer)(arrayItem = this.stack.getStackItem(1)).getUserValue()) != null && index >= sz) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AIOB_ARRAY_INDEX_OUT_OF_BOUNDS.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void processArrayStore() {
        OpcodeStack.Item indexItem;
        Number index;
        if (this.stack.getStackDepth() >= 3 && (index = (Number)(indexItem = this.stack.getStackItem(1)).getConstant()) != null) {
            int reg;
            OpcodeStack.Item arrayItem = this.stack.getStackItem(2);
            Integer sz = (Integer)arrayItem.getUserValue();
            if (sz != null && index.intValue() >= sz) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AIOB_ARRAY_INDEX_OUT_OF_BOUNDS.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if ((reg = arrayItem.getRegisterNumber()) >= 0 && !this.initializedRegs.get(reg)) {
                this.nullStoreToLocation.put(reg, this.getPC());
            }
        }
    }
}

