/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class BloatedAssignmentScope
extends BytecodeScanningDetector {
    private static final Set<String> dangerousAssignmentClassSources = UnmodifiableSet.create("java/io/BufferedInputStream", "java/io/DataInput", "java/io/DataInputStream", "java/io/InputStream", "java/io/ObjectInputStream", "java/io/BufferedReader", "java/io/FileReader", "java/io/Reader", "javax/nio/channels/Channel", "io/netty/channel/Channel");
    private static final Set<String> dangerousAssignmentMethodSources = UnmodifiableSet.create("java/lang/System.currentTimeMillis()J", "java/lang/System.nanoTime()J", "java/util/Calendar.get(I)I", "java/util/GregorianCalendar.get(I)I", "java/util/Iterator.next()Ljava/lang/Object;", "java/util/regex/Matcher.start()I", "java/util/concurrent/TimeUnit.toMillis(J)J");
    private static final Set<Pattern> dangerousAssignmentMethodPatterns = UnmodifiableSet.create(Pattern.compile(".*serial.*", 2), Pattern.compile(".*\\.read[^.]*", 2), Pattern.compile(".*\\.create[^.]*", 2));
    private static final Set<String> dangerousStoreClassSigs = UnmodifiableSet.create("Ljava/util/concurrent/Future;");
    BugReporter bugReporter;
    private OpcodeStack stack;
    private BitSet ignoreRegs;
    private ScopeBlock rootScopeBlock;
    private BitSet tryBlocks;
    private BitSet catchHandlers;
    private BitSet switchTargets;
    private List<Integer> monitorSyncPCs;
    private boolean dontReport;
    private boolean sawDup;
    private boolean sawNull;

    public BloatedAssignmentScope(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.ignoreRegs = new BitSet();
            this.tryBlocks = new BitSet();
            this.catchHandlers = new BitSet();
            this.switchTargets = new BitSet();
            this.monitorSyncPCs = new ArrayList<Integer>(5);
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.ignoreRegs = null;
            this.tryBlocks = null;
            this.catchHandlers = null;
            this.switchTargets = null;
            this.monitorSyncPCs = null;
            this.stack = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            int[] parmRegs;
            this.ignoreRegs.clear();
            Method method = this.getMethod();
            if (!method.isStatic()) {
                this.ignoreRegs.set(0);
            }
            for (int parm : parmRegs = RegisterUtils.getParameterRegisters(method)) {
                this.ignoreRegs.set(parm);
            }
            this.rootScopeBlock = new ScopeBlock(0, obj.getLength());
            this.tryBlocks.clear();
            this.catchHandlers.clear();
            CodeException[] exceptions = obj.getExceptionTable();
            if (exceptions != null) {
                for (CodeException ex : exceptions) {
                    this.tryBlocks.set(ex.getStartPC());
                    this.catchHandlers.set(ex.getHandlerPC());
                }
            }
            this.switchTargets.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.dontReport = false;
            this.sawDup = false;
            this.sawNull = false;
            super.visitCode(obj);
            if (!this.dontReport) {
                this.rootScopeBlock.findBugs(new HashSet<Integer>());
            }
        }
        finally {
            this.rootScopeBlock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        UserObject uo = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            int pc = this.getPC();
            if (this.tryBlocks.get(pc)) {
                ScopeBlock sb = new ScopeBlock(pc, this.findCatchHandlerFor(pc));
                sb.setTry();
                this.rootScopeBlock.addChild(sb);
            }
            if (OpcodeUtils.isStore(seen)) {
                this.sawStore(seen, pc);
            } else if (seen == 132) {
                this.sawIINC(pc);
            } else if (OpcodeUtils.isLoad(seen)) {
                this.sawLoad(seen, pc);
            } else if (seen >= 153 && seen <= 167 || seen == 198 || seen == 199 || seen == 200) {
                this.sawBranch(seen, pc);
            } else if (seen == 170 || seen == 171) {
                this.sawSwitch(pc);
            } else if (seen == 182 || seen == 185) {
                uo = this.sawInstanceCall(pc);
            } else if (seen == 184 || seen == 183) {
                uo = this.sawStaticCall();
            } else if (seen == 194) {
                this.sawMonitorEnter(pc);
            } else if (seen == 195) {
                this.sawMonitorExit(pc);
            }
            this.sawDup = seen == 89;
            this.sawNull = seen == 1;
        }
        catch (Throwable throwable) {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (uo != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(uo);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (uo != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)uo);
        }
    }

    private void sawStore(int seen, int pc) {
        int reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
        if (this.catchHandlers.get(pc)) {
            this.ignoreRegs.set(reg);
            ScopeBlock catchSB = this.findScopeBlock(this.rootScopeBlock, pc + 1);
            if (catchSB != null && catchSB.getStart() < pc) {
                ScopeBlock sb = new ScopeBlock(pc, catchSB.getFinish());
                catchSB.setFinish(this.getPC() - 1);
                this.rootScopeBlock.addChild(sb);
            }
        } else if (this.monitorSyncPCs.size() > 0) {
            this.ignoreRegs.set(reg);
        } else if (this.sawNull) {
            this.ignoreRegs.set(reg);
        } else if (this.isRiskyStoreClass(reg)) {
            this.ignoreRegs.set(reg);
        }
        if (!this.ignoreRegs.get(reg)) {
            ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, pc);
            if (sb != null) {
                UserObject assoc = null;
                if (this.stack.getStackDepth() > 0) {
                    assoc = (UserObject)this.stack.getStackItem(0).getUserValue();
                }
                if (assoc != null && assoc.isRisky) {
                    this.ignoreRegs.set(reg);
                } else {
                    sb.addStore(reg, pc, assoc);
                    if (this.sawDup) {
                        sb.addLoad(reg, pc);
                    }
                }
            } else {
                this.ignoreRegs.set(reg);
            }
        }
    }

    private void sawIINC(int pc) {
        ScopeBlock sb;
        int reg = this.getRegisterOperand();
        if (!this.ignoreRegs.get(reg)) {
            sb = this.findScopeBlock(this.rootScopeBlock, pc);
            if (sb != null) {
                sb.addLoad(reg, pc);
            } else {
                this.ignoreRegs.set(reg);
            }
        }
        if (this.catchHandlers.get(pc)) {
            this.ignoreRegs.set(reg);
        } else if (this.monitorSyncPCs.size() > 0) {
            this.ignoreRegs.set(reg);
        } else if (this.sawNull) {
            this.ignoreRegs.set(reg);
        }
        if (!this.ignoreRegs.get(reg)) {
            sb = this.findScopeBlock(this.rootScopeBlock, pc);
            if (sb != null) {
                sb.addStore(reg, pc, null);
                if (this.sawDup) {
                    sb.addLoad(reg, pc);
                }
            } else {
                this.ignoreRegs.set(reg);
            }
        }
    }

    private void sawLoad(int seen, int pc) {
        int reg = RegisterUtils.getLoadReg((DismantleBytecode)this, seen);
        if (!this.ignoreRegs.get(reg)) {
            ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, pc);
            if (sb != null) {
                sb.addLoad(reg, pc);
            } else {
                this.ignoreRegs.set(reg);
            }
        }
    }

    private void sawBranch(int seen, int pc) {
        int target = this.getBranchTarget();
        if (target > pc) {
            if (seen == 167 || seen == 200) {
                int nextPC = this.getNextPC();
                if (!this.switchTargets.get(nextPC)) {
                    ScopeBlock sb = this.findScopeBlockWithTarget(this.rootScopeBlock, pc, nextPC);
                    if (sb == null) {
                        sb = new ScopeBlock(pc, target);
                        sb.setLoop();
                        sb.setGoto();
                        this.rootScopeBlock.addChild(sb);
                    } else {
                        sb = new ScopeBlock(nextPC, target);
                        sb.setGoto();
                        this.rootScopeBlock.addChild(sb);
                    }
                }
            } else {
                ScopeBlock sb = this.findScopeBlockWithTarget(this.rootScopeBlock, pc, target);
                if (!(sb == null || sb.isLoop() || sb.isCase() || sb.hasChildren())) {
                    if (sb.isGoto()) {
                        ScopeBlock parent = sb.getParent();
                        sb.pushUpLoadStores();
                        if (parent != null) {
                            parent.removeChild(sb);
                        }
                        sb = new ScopeBlock(pc, target);
                        this.rootScopeBlock.addChild(sb);
                    } else {
                        sb.pushUpLoadStores();
                        sb.setStart(pc);
                    }
                } else {
                    sb = new ScopeBlock(pc, target);
                    this.rootScopeBlock.addChild(sb);
                }
            }
        } else {
            ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, pc);
            if (sb != null) {
                ScopeBlock previous;
                for (ScopeBlock parentSB = sb.getParent(); parentSB != null && parentSB.getStart() >= target; parentSB = parentSB.getParent()) {
                    sb = parentSB;
                }
                if (sb.getStart() > target && (previous = this.findPreviousSiblingScopeBlock(sb)) != null && previous.getStart() >= target) {
                    sb = previous;
                }
                sb.setLoop();
            }
        }
    }

    private void sawSwitch(int pc) {
        int[] offsets = this.getSwitchOffsets();
        ArrayList<Integer> targets = new ArrayList<Integer>(offsets.length);
        for (int offset : offsets) {
            targets.add(offset + pc);
        }
        Integer defOffset = this.getDefaultSwitchOffset() + pc;
        if (!targets.contains(defOffset)) {
            targets.add(defOffset);
        }
        Collections.sort(targets);
        Integer lastTarget = (Integer)targets.get(0);
        for (int i = 1; i < targets.size(); ++i) {
            Integer nextTarget = (Integer)targets.get(i);
            ScopeBlock sb = new ScopeBlock(lastTarget, nextTarget);
            sb.setCase();
            this.rootScopeBlock.addChild(sb);
            lastTarget = nextTarget;
        }
        for (Integer target : targets) {
            this.switchTargets.set(target);
        }
    }

    private UserObject sawInstanceCall(int pc) {
        ScopeBlock sb;
        String signature = this.getSigConstantOperand();
        if ("wasNull".equals(this.getNameConstantOperand()) && "()Z".equals(signature)) {
            this.dontReport = true;
        }
        if (signature.endsWith("V")) {
            return null;
        }
        UserObject uo = new UserObject();
        uo.isRisky = this.isRiskyMethodCall();
        uo.caller = this.getCallingObject();
        if (uo.caller != null && (sb = this.findScopeBlock(this.rootScopeBlock, pc)) != null) {
            sb.removeByAssoc(uo.caller);
        }
        return uo;
    }

    private UserObject sawStaticCall() {
        if (this.getSigConstantOperand().endsWith("V")) {
            return null;
        }
        UserObject uo = new UserObject();
        uo.isRisky = this.isRiskyMethodCall();
        return uo;
    }

    private void sawMonitorEnter(int pc) {
        this.monitorSyncPCs.add(pc);
        ScopeBlock sb = new ScopeBlock(pc, Integer.MAX_VALUE);
        sb.setSync();
        this.rootScopeBlock.addChild(sb);
    }

    private void sawMonitorExit(int pc) {
        if (this.monitorSyncPCs.size() > 0) {
            ScopeBlock sb = this.findSynchronizedScopeBlock(this.rootScopeBlock, this.monitorSyncPCs.get(0));
            if (sb != null) {
                sb.setFinish(pc);
            }
            this.monitorSyncPCs.remove(this.monitorSyncPCs.size() - 1);
        }
    }

    private Comparable<?> getCallingObject() {
        String sig = this.getSigConstantOperand();
        if ("V".equals(Type.getReturnType((String)sig).getSignature())) {
            return null;
        }
        Type[] types = Type.getArgumentTypes((String)sig);
        if (this.stack.getStackDepth() <= types.length) {
            return null;
        }
        OpcodeStack.Item caller = this.stack.getStackItem(types.length);
        int reg = caller.getRegisterNumber();
        if (reg >= 0) {
            return reg;
        }
        XField f = caller.getXField();
        if (f != null) {
            return f.getName();
        }
        return null;
    }

    private ScopeBlock findScopeBlock(ScopeBlock sb, int pc) {
        if (pc > sb.getStart() && pc < sb.getFinish()) {
            if (sb.children != null) {
                for (ScopeBlock child : sb.children) {
                    ScopeBlock foundSb = this.findScopeBlock(child, pc);
                    if (foundSb == null) continue;
                    return foundSb;
                }
            }
            return sb;
        }
        return null;
    }

    private ScopeBlock findScopeBlockWithTarget(ScopeBlock sb, int start, int target) {
        ScopeBlock parentBlock = null;
        if (sb.startLocation < start && sb.finishLocation >= start && (sb.finishLocation <= target || sb.isGoto() && !sb.isLoop())) {
            parentBlock = sb;
        }
        if (sb.children != null) {
            for (ScopeBlock child : sb.children) {
                ScopeBlock targetBlock = this.findScopeBlockWithTarget(child, start, target);
                if (targetBlock == null) continue;
                return targetBlock;
            }
        }
        return parentBlock;
    }

    private ScopeBlock findPreviousSiblingScopeBlock(ScopeBlock sb) {
        ScopeBlock parent = sb.getParent();
        if (parent == null) {
            return null;
        }
        List<ScopeBlock> children = parent.getChildren();
        if (children == null) {
            return null;
        }
        ScopeBlock lastSibling = null;
        for (ScopeBlock sibling : children) {
            if (sibling.equals(sb)) {
                return lastSibling;
            }
            lastSibling = sibling;
        }
        return null;
    }

    private ScopeBlock findSynchronizedScopeBlock(ScopeBlock sb, int monitorEnterPC) {
        ScopeBlock monitorBlock = sb;
        if (sb.hasChildren()) {
            for (ScopeBlock child : sb.getChildren()) {
                if (!child.isSync() || child.getStart() <= monitorBlock.getStart()) continue;
                monitorBlock = child;
                monitorBlock = this.findSynchronizedScopeBlock(monitorBlock, monitorEnterPC);
            }
        }
        return monitorBlock;
    }

    private int findCatchHandlerFor(int pc) {
        CodeException[] exceptions = this.getMethod().getCode().getExceptionTable();
        if (exceptions != null) {
            for (CodeException ex : exceptions) {
                if (ex.getStartPC() != pc) continue;
                return ex.getHandlerPC();
            }
        }
        return -1;
    }

    public boolean isRiskyMethodCall() {
        String clsName = this.getClassConstantOperand();
        if (dangerousAssignmentClassSources.contains(clsName)) {
            return true;
        }
        String key = clsName + '.' + this.getNameConstantOperand() + this.getSigConstantOperand();
        if (dangerousAssignmentMethodSources.contains(key)) {
            return true;
        }
        for (Pattern p : dangerousAssignmentMethodPatterns) {
            Matcher m = p.matcher(key);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isRiskyStoreClass(int reg) {
        LocalVariable lv;
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        return lvt != null && (lv = lvt.getLocalVariable(reg, this.getNextPC())) != null && dangerousStoreClassSigs.contains(lv.getSignature());
    }

    static class UserObject {
        Comparable<?> caller;
        boolean isRisky;

        UserObject() {
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    private class ScopeBlock {
        private ScopeBlock parent = null;
        private int startLocation;
        private int finishLocation;
        private boolean isLoop;
        private boolean isGoto;
        private boolean isSync;
        private boolean isTry;
        private boolean isCase;
        private Map<Integer, Integer> loads;
        private Map<Integer, Integer> stores;
        private Map<UserObject, Integer> assocs;
        private List<ScopeBlock> children;

        public ScopeBlock(int start, int finish) {
            this.startLocation = start;
            this.finishLocation = finish;
            this.isLoop = false;
            this.isGoto = false;
            this.isSync = false;
            this.isTry = false;
            this.isCase = false;
            this.loads = null;
            this.stores = null;
            this.assocs = null;
            this.children = null;
        }

        public String toString() {
            return ToString.build(this);
        }

        public ScopeBlock getParent() {
            return this.parent;
        }

        public List<ScopeBlock> getChildren() {
            return this.children;
        }

        public int getStart() {
            return this.startLocation;
        }

        public int getFinish() {
            return this.finishLocation;
        }

        public void setStart(int start) {
            this.startLocation = start;
        }

        public void setFinish(int finish) {
            this.finishLocation = finish;
        }

        public boolean hasChildren() {
            return this.children != null;
        }

        public void setLoop() {
            this.isLoop = true;
        }

        public boolean isLoop() {
            return this.isLoop;
        }

        public void setGoto() {
            this.isGoto = true;
        }

        public boolean isGoto() {
            return this.isGoto;
        }

        public void setSync() {
            this.isSync = true;
        }

        public boolean isSync() {
            return this.isSync;
        }

        public void setTry() {
            this.isTry = true;
        }

        public boolean isTry() {
            return this.isTry;
        }

        public void setCase() {
            this.isCase = true;
        }

        public boolean isCase() {
            return this.isCase;
        }

        public void addStore(int reg, int pc, UserObject assocObject) {
            if (this.stores == null) {
                this.stores = new HashMap<Integer, Integer>(6);
            }
            this.stores.put(reg, pc);
            if (this.assocs == null) {
                this.assocs = new HashMap<UserObject, Integer>(6);
            }
            this.assocs.put(assocObject, reg);
        }

        public void removeByAssoc(Object assocObject) {
            Integer reg;
            if (this.assocs != null && (reg = this.assocs.remove(assocObject)) != null) {
                if (this.loads != null) {
                    this.loads.remove(reg);
                }
                if (this.stores != null) {
                    this.stores.remove(reg);
                }
            }
        }

        public void addLoad(int reg, int pc) {
            if (this.loads == null) {
                this.loads = new HashMap<Integer, Integer>(10);
            }
            this.loads.put(reg, pc);
        }

        public void addChild(ScopeBlock newChild) {
            newChild.parent = this;
            if (this.children != null) {
                for (ScopeBlock child : this.children) {
                    if (newChild.startLocation <= child.startLocation || newChild.startLocation >= child.finishLocation) continue;
                    if (newChild.finishLocation > child.finishLocation) {
                        newChild.finishLocation = child.finishLocation;
                    }
                    child.addChild(newChild);
                    return;
                }
                int pos = 0;
                for (ScopeBlock child : this.children) {
                    if (newChild.startLocation < child.startLocation) {
                        this.children.add(pos, newChild);
                        return;
                    }
                    ++pos;
                }
                this.children.add(newChild);
                return;
            }
            this.children = new ArrayList<ScopeBlock>();
            this.children.add(newChild);
        }

        public void removeChild(ScopeBlock child) {
            if (this.children != null) {
                this.children.remove(child);
            }
        }

        public void findBugs(Set<Integer> parentUsedRegs) {
            if (this.isLoop) {
                return;
            }
            HashSet<Integer> usedRegs = new HashSet<Integer>(parentUsedRegs);
            if (this.stores != null) {
                usedRegs.addAll(this.stores.keySet());
            }
            if (this.loads != null) {
                usedRegs.addAll(this.loads.keySet());
            }
            if (this.stores != null) {
                if (this.loads != null) {
                    this.stores.keySet().removeAll(this.loads.keySet());
                }
                this.stores.keySet().removeAll(parentUsedRegs);
                int r = BloatedAssignmentScope.this.ignoreRegs.nextSetBit(0);
                while (r >= 0) {
                    this.stores.remove(r);
                    r = BloatedAssignmentScope.this.ignoreRegs.nextSetBit(r + 1);
                }
                if (this.children != null && this.stores.size() > 0) {
                    for (Map.Entry<Integer, Integer> entry : this.stores.entrySet()) {
                        int childUseCount = 0;
                        boolean inIgnoreSB = false;
                        Integer reg = entry.getKey();
                        for (ScopeBlock child : this.children) {
                            if (!child.usesReg(reg)) continue;
                            if (child.isLoop || child.isSync() || child.isTry()) {
                                inIgnoreSB = true;
                                break;
                            }
                            ++childUseCount;
                        }
                        if (inIgnoreSB || childUseCount != true) continue;
                        BloatedAssignmentScope.this.bugReporter.reportBug(new BugInstance((Detector)BloatedAssignmentScope.this, BugType.BAS_BLOATED_ASSIGNMENT_SCOPE.name(), 2).addClass((PreorderVisitor)BloatedAssignmentScope.this).addMethod((PreorderVisitor)BloatedAssignmentScope.this).addSourceLine((BytecodeScanningDetector)BloatedAssignmentScope.this, entry.getValue().intValue()));
                    }
                }
            }
            if (this.children != null) {
                for (ScopeBlock child : this.children) {
                    child.findBugs(usedRegs);
                }
            }
        }

        public boolean usesReg(Integer reg) {
            if (this.loads != null && this.loads.containsKey(reg)) {
                return true;
            }
            if (this.stores != null && this.stores.containsKey(reg)) {
                return true;
            }
            if (this.children != null) {
                for (ScopeBlock child : this.children) {
                    if (!child.usesReg(reg)) continue;
                    return true;
                }
            }
            return false;
        }

        public void pushUpLoadStores() {
            if (this.parent != null) {
                if (this.loads != null) {
                    if (this.parent.loads != null) {
                        this.parent.loads.putAll(this.loads);
                    } else {
                        this.parent.loads = this.loads;
                    }
                }
                if (this.stores != null) {
                    if (this.parent.stores != null) {
                        this.parent.stores.putAll(this.stores);
                    } else {
                        this.parent.stores = this.stores;
                    }
                }
                this.loads = null;
                this.stores = null;
            }
        }
    }
}

