/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BogusExceptionDeclaration
extends BytecodeScanningDetector {
    private static JavaClass runtimeExceptionClass;
    private static JavaClass exceptionClass;
    private static final Set<String> safeClasses;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<String> declaredCheckedExceptions;
    private boolean classIsFinal;
    private boolean classIsAnonymous;

    public BogusExceptionDeclaration(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            if (runtimeExceptionClass != null && exceptionClass != null) {
                this.stack = new OpcodeStack();
                this.declaredCheckedExceptions = new HashSet<String>(6);
                JavaClass cls = classContext.getJavaClass();
                this.classIsFinal = cls.isFinal();
                this.classIsAnonymous = cls.isAnonymous();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.declaredCheckedExceptions = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.declaredCheckedExceptions.clear();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        Method method = this.getMethod();
        if (method.isSynthetic()) {
            return;
        }
        ExceptionTable et = method.getExceptionTable();
        if (et != null) {
            String[] exNames;
            if (this.classIsFinal || this.classIsAnonymous || method.isStatic() || method.isPrivate() || method.isFinal() || "<init>".equals(method.getName()) && !BogusExceptionDeclaration.isAnonymousInnerCtor(method, this.getThisClass())) {
                for (String exName : exNames = et.getExceptionNames()) {
                    try {
                        JavaClass exCls = Repository.lookupClass((String)exName);
                        if (exCls.instanceOf(runtimeExceptionClass)) continue;
                        this.declaredCheckedExceptions.add(exName);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
                if (!this.declaredCheckedExceptions.isEmpty()) {
                    super.visitCode(obj);
                    if (!this.declaredCheckedExceptions.isEmpty()) {
                        BugInstance bi = new BugInstance((Detector)this, BugType.BED_BOGUS_EXCEPTION_DECLARATION.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0);
                        for (String ex : this.declaredCheckedExceptions) {
                            bi.addString(ex.replaceAll("/", "."));
                        }
                        this.bugReporter.reportBug(bi);
                    }
                }
            }
            if (!method.isSynthetic()) {
                exNames = et.getExceptionNames();
                for (int i = 0; i < exNames.length - 1; ++i) {
                    try {
                        JavaClass exCls1 = Repository.lookupClass((String)exNames[i]);
                        for (int j = i + 1; j < exNames.length; ++j) {
                            JavaClass parentEx;
                            JavaClass childEx;
                            JavaClass exCls2 = Repository.lookupClass((String)exNames[j]);
                            if (exCls1.instanceOf(exCls2)) {
                                childEx = exCls1;
                                parentEx = exCls2;
                            } else {
                                if (!exCls2.instanceOf(exCls1)) continue;
                                childEx = exCls2;
                                parentEx = exCls1;
                            }
                            if (parentEx.equals((Object)exceptionClass)) continue;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.BED_HIERARCHICAL_EXCEPTION_DECLARATION.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString(childEx.getClassName() + " derives from " + parentEx.getClassName()));
                            return;
                        }
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
            }
        }
    }

    private static boolean isAnonymousInnerCtor(Method m, JavaClass cls) {
        if (!"<init>".equals(m.getName())) {
            return false;
        }
        String clsName = cls.getClassName();
        int dollarPos = clsName.lastIndexOf(36);
        if (dollarPos < 0) {
            return false;
        }
        String signature = m.getSignature();
        return ("(L" + clsName.substring(0, dollarPos).replace('.', '/') + ";)V").equals(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block16: {
            if (this.declaredCheckedExceptions.isEmpty()) {
                return;
            }
            try {
                this.stack.precomputation((DismantleBytecode)this);
                if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
                    String clsName = this.getClassConstantOperand();
                    if (!safeClasses.contains(clsName)) {
                        try {
                            JavaClass cls = Repository.lookupClass((String)clsName);
                            Method[] methods = cls.getMethods();
                            String methodName = this.getNameConstantOperand();
                            String signature = this.getSigConstantOperand();
                            boolean found = false;
                            for (Method m : methods) {
                                if (!m.getName().equals(methodName) || !m.getSignature().equals(signature)) continue;
                                ExceptionTable et = m.getExceptionTable();
                                if (et != null) {
                                    String[] thrownExceptions;
                                    for (String thrownException : thrownExceptions = et.getExceptionNames()) {
                                        this.removeThrownExceptionHierarchy(thrownException);
                                    }
                                }
                                found = true;
                                break;
                            }
                            if (!found) {
                                this.declaredCheckedExceptions.clear();
                            }
                            break block16;
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.bugReporter.reportMissingClass(cnfe);
                            this.declaredCheckedExceptions.clear();
                        }
                        break block16;
                    }
                    if ("wait".equals(this.getNameConstantOperand())) {
                        this.declaredCheckedExceptions.remove("java.lang.InterruptedException");
                    }
                    break block16;
                }
                if (seen == 191) {
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        String exSig = item.getSignature();
                        String thrownException = SignatureUtils.stripSignature(exSig);
                        this.removeThrownExceptionHierarchy(thrownException);
                    } else {
                        this.declaredCheckedExceptions.clear();
                    }
                }
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
            }
        }
    }

    private void removeThrownExceptionHierarchy(String thrownException) {
        try {
            this.declaredCheckedExceptions.remove(thrownException);
            JavaClass exCls = Repository.lookupClass((String)thrownException);
            while ((exCls = exCls.getSuperClass()) != null) {
                this.declaredCheckedExceptions.remove(exCls.getClassName());
                if (!this.declaredCheckedExceptions.isEmpty() && !"java.lang.Exception".equals(exCls.getClassName()) && !"java.lang.Error".equals(exCls.getClassName())) continue;
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            this.declaredCheckedExceptions.clear();
        }
    }

    static {
        safeClasses = UnmodifiableSet.create("java/lang/Object", "java/lang/String", "java/lang/Integer", "java/lang/Long", "java/lang/Float", "java/lang/Double", "java/lang/Short", "java/lang/Boolean");
        try {
            runtimeExceptionClass = Repository.lookupClass((String)"java/lang/RuntimeException");
            exceptionClass = Repository.lookupClass((String)"java/lang/Exception");
        }
        catch (ClassNotFoundException cnfe) {
            runtimeExceptionClass = null;
            exceptionClass = null;
        }
    }
}

