/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import com.mebigfatguy.fbcontrib.utils.PublicAPI;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class CharsetIssues
extends BytecodeScanningDetector {
    private static final String CHARSET_SIG = "Ljava/nio/charset/Charset;";
    private static final Map<FQMethod, Integer> REPLACEABLE_ENCODING_METHODS;
    private static final Map<FQMethod, Integer> UNREPLACEABLE_ENCODING_METHODS;
    public static final Set<String> STANDARD_JDK7_ENCODINGS;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private int classVersion;

    public CharsetIssues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.classVersion = classContext.getJavaClass().getMajor();
            if (this.classVersion >= 48) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    encoding = null;
                    className = this.getClassConstantOperand();
                    methodName = this.getNameConstantOperand();
                    methodSig = this.getSigConstantOperand();
                    methodInfo = new FQMethod(className, methodName, methodSig);
                    stackOffset = CharsetIssues.REPLACEABLE_ENCODING_METHODS.get(methodInfo);
                    if (stackOffset != null) {
                        offset = stackOffset;
                        if (this.stack.getStackDepth() > offset && (encoding = (String)(item = this.stack.getStackItem(offset)).getConstant()) != null) {
                            encoding = encoding.toUpperCase(Locale.ENGLISH);
                            if (this.classVersion >= 51 && CharsetIssues.STANDARD_JDK7_ENCODINGS.contains(encoding)) {
                                changedMethodSig = CharsetIssues.replaceNthArgWithCharsetString(methodSig, offset);
                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_USE_STANDARD_CHARSET.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this).addCalledMethod(className, methodName, changedMethodSig, seen == 184));
                            }
                        }
                    } else {
                        offsetValue = CharsetIssues.UNREPLACEABLE_ENCODING_METHODS.get(methodInfo);
                        if (offsetValue != null) {
                            offset = offsetValue;
                            if (this.stack.getStackDepth() > offset && (encoding = (String)(item = this.stack.getStackItem(offset)).getConstant()) != null) {
                                encoding = encoding.toUpperCase(Locale.ENGLISH);
                                if (this.classVersion >= 51 && CharsetIssues.STANDARD_JDK7_ENCODINGS.contains(encoding)) {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_USE_STANDARD_CHARSET_NAME.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
                                }
                            }
                        }
                    }
                    if (encoding == null) ** break;
                    try {
                        Charset.forName(encoding);
                        ** break;
lbl31:
                        // 1 sources

                    }
                    catch (IllegalArgumentException e) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_UNKNOWN_ENCODING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this).addString(encoding));
                        ** break;
                    }
lbl35:
                    // 1 sources

                    break;
                }
                ** default:
lbl37:
                // 1 sources

                break;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static String replaceNthArgWithCharsetString(String sig, int stackOffset) {
        Type[] arguments = Type.getArgumentTypes((String)sig);
        StringBuilder sb = new StringBuilder("(");
        int argumentIndexToReplace = arguments.length - stackOffset - 1;
        for (int i = 0; i < arguments.length; ++i) {
            if (i == argumentIndexToReplace) {
                sb.append(CHARSET_SIG);
                continue;
            }
            sb.append(arguments[i].getSignature());
        }
        sb.append(sig.substring(sig.lastIndexOf(41), sig.length()));
        return sb.toString();
    }

    @PublicAPI(value="Used by fb-contrib-eclipse-quickfixes to determine type of fix to apply")
    public static Map<String, Integer> getUnreplaceableCharsetEncodings() {
        HashMap<String, Integer> encodings = new HashMap<String, Integer>();
        for (Map.Entry<FQMethod, Integer> entry : UNREPLACEABLE_ENCODING_METHODS.entrySet()) {
            encodings.put(entry.getKey().toString(), entry.getValue());
        }
        return encodings;
    }

    @PublicAPI(value="Used by fb-contrib-eclipse-quickfixes to determine type of fix to apply")
    public static Map<String, Integer> getReplaceableCharsetEncodings() {
        HashMap<String, Integer> encodings = new HashMap<String, Integer>();
        for (Map.Entry<FQMethod, Integer> entry : REPLACEABLE_ENCODING_METHODS.entrySet()) {
            encodings.put(entry.getKey().toString(), entry.getValue());
        }
        return encodings;
    }

    static {
        STANDARD_JDK7_ENCODINGS = UnmodifiableSet.create("US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16");
        HashMap<FQMethod, Integer> replaceable = new HashMap<FQMethod, Integer>(8);
        replaceable.put(new FQMethod("java/io/InputStreamReader", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;)V"), Values.ZERO);
        replaceable.put(new FQMethod("java/io/OutputStreamWriter", "<init>", "(Ljava/io/OutputStream;Ljava/lang/String;)V"), Values.ZERO);
        replaceable.put(new FQMethod("java/lang/String", "<init>", "([BLjava/lang/String;)V"), Values.ZERO);
        replaceable.put(new FQMethod("java/lang/String", "<init>", "([BIILjava/lang/String;)V"), Values.ZERO);
        replaceable.put(new FQMethod("java/lang/String", "getBytes", "(Ljava/lang/String;)[B"), Values.ZERO);
        replaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/io/File;Ljava/lang/String;Ljava/util/Locale;)V"), Values.ONE);
        REPLACEABLE_ENCODING_METHODS = Collections.unmodifiableMap(replaceable);
        HashMap<FQMethod, Integer> unreplaceable = new HashMap<FQMethod, Integer>(32);
        unreplaceable.put(new FQMethod("java/net/URLEncoder", "encode", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/net/URLDecoder", "decode", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/ByteArrayOutputStream", "toString", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintStream", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintStream", "<init>", "(Ljava/io/File;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintStream", "<init>", "(Ljava/io/OutputStream;BLjava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintStream", "toCharset", "(Ljava/lang/String;)Ljava/nio/charset/Charset;"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintWriter", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintWriter", "<init>", "(Ljava/io/File;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/io/PrintWriter", "toCharset", "(Ljava/lang/String;)Ljava/nio/charset/Charset;"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/lang/StringCoding", "decode", "(Ljava/lang/String;[BII)[C"), Values.THREE);
        unreplaceable.put(new FQMethod("java/lang/StringCoding", "encode", "(Ljava/lang/String;[CII)[B"), Values.THREE);
        unreplaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/io/File;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/io/OutputStream;Ljava/lang/String;Ljava/util/Locale;)V"), Values.ONE);
        unreplaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/io/OutputStream;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;)V"), Values.ONE);
        unreplaceable.put(new FQMethod("java/util/Formatter", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Formatter", "toCharset", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/logging/Handler", "setEncoding", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/logging/MemoryHandler", "setEncoding", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/logging/StreamHandler", "setEncoding", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Scanner", "<init>", "(Ljava/io/File;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Scanner", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Scanner", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/util/Scanner", "<init>", "(Ljava/nio/channels/ReadableByteChannel;Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/lang/StringCoding", "decode", "(Ljava/lang/String;[BII)[C"), Values.THREE);
        unreplaceable.put(new FQMethod("java/lang/StringCoding", "encode", "(Ljava/lang/String;[CII)[B"), Values.THREE);
        unreplaceable.put(new FQMethod("javax/servlet/ServletResponse", "setCharacterEncoding", "(Ljava/lang/String;)V"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/beans/XMLEncoder", "<init>", "(Ljava/io/OutputStream;Ljava/lang/String;ZI)V"), Values.TWO);
        unreplaceable.put(new FQMethod("java/nio/channels/Channels", "newReader", "(Ljava/nio/channels/ReadableByteChannel;Ljava/lang/String;)Ljava/io/Reader;"), Values.ZERO);
        unreplaceable.put(new FQMethod("java/nio/channels/Channels", "newWriter", "(Ljava/nio/channels/WritableByteChannel;Ljava/lang/String;)Ljava/io/Writer;"), Values.ZERO);
        UNREPLACEABLE_ENCODING_METHODS = Collections.unmodifiableMap(unreplaceable);
    }
}

