/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class CloneUsability
extends BytecodeScanningDetector {
    private static JavaClass CLONE_CLASS;
    private BugReporter bugReporter;
    private JavaClass cls;
    private String clsName;
    private OpcodeStack stack;
    private boolean throwsCNFE;

    public CloneUsability(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.cls = classContext.getJavaClass();
            if (this.cls.implementationOf(CLONE_CLASS)) {
                this.clsName = this.cls.getClassName();
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.cls = null;
            this.stack = null;
        }
    }

    @SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="False positives occur when state is maintained across callbacks")
    public void visitCode(Code obj) {
        try {
            Method m = this.getMethod();
            if (m.isPublic() && !m.isSynthetic() && "clone".equals(m.getName()) && m.getArgumentTypes().length == 0) {
                ExceptionTable et;
                String returnClsName = m.getReturnType().getSignature();
                if (!this.clsName.equals(returnClsName = SignatureUtils.stripSignature(returnClsName))) {
                    if ("java.lang.Object".equals(returnClsName)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CU_CLONE_USABILITY_OBJECT_RETURN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                    } else {
                        JavaClass cloneClass = Repository.lookupClass((String)returnClsName);
                        if (!this.cls.instanceOf(cloneClass)) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CU_CLONE_USABILITY_MISMATCHED_RETURN.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                        }
                    }
                }
                if ((et = m.getExceptionTable()) != null && et.getLength() > 0) {
                    this.throwsCNFE = false;
                    if (this.prescreen(m)) {
                        this.stack.resetForMethodEntry((DismantleBytecode)this);
                        super.visitCode(obj);
                    }
                    if (!this.throwsCNFE) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CU_CLONE_USABILITY_THROWS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item item;
            if (seen == 191 && this.stack.getStackDepth() > 0 && "Ljava/lang/CloneNotSupportedException;".equals((item = this.stack.getStackItem(0)).getSignature())) {
                this.throwsCNFE = true;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(191);
    }

    static {
        try {
            CLONE_CLASS = Repository.lookupClass((String)"java/lang/Cloneable");
        }
        catch (ClassNotFoundException cnfe) {
            CLONE_CLASS = null;
        }
    }
}

