/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class CollectionNamingConfusion
extends PreorderVisitor
implements Detector {
    private static JavaClass MAP_CLASS;
    private static JavaClass SET_CLASS;
    private static JavaClass LIST_CLASS;
    private static JavaClass QUEUE_CLASS;
    private BugReporter bugReporter;
    private ClassContext classContext;

    public CollectionNamingConfusion(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (MAP_CLASS != null) {
            this.classContext = classContext;
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    public void visitField(Field obj) {
        if (this.checkConfusedName(obj.getName(), obj.getSignature())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CNC_COLLECTION_NAMING_CONFUSION.name(), 2).addClass((PreorderVisitor)this).addField((PreorderVisitor)this).addString(obj.getName()));
        }
    }

    public void visitMethod(Method obj) {
        LocalVariableTable lvt = obj.getLocalVariableTable();
        if (lvt != null) {
            LocalVariable[] lvs;
            for (LocalVariable lv : lvs = lvt.getLocalVariableTable()) {
                if (!this.checkConfusedName(lv.getName(), lv.getSignature())) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CNC_COLLECTION_NAMING_CONFUSION.name(), 2).addClass((PreorderVisitor)this).addString(lv.getName()).addSourceLine(this.classContext, (PreorderVisitor)this, lv.getStartPC()));
            }
        }
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_RETURN_FALSE"}, justification="No other simple way to determine whether class exists")
    private boolean checkConfusedName(String name, String signature) {
        try {
            name = name.toLowerCase();
            if ((name.endsWith("map") || name.endsWith("set") && !name.endsWith("toset") || name.endsWith("list") || name.endsWith("queue")) && signature.startsWith("Ljava/util/")) {
                String clsName = SignatureUtils.stripSignature(signature);
                JavaClass cls = Repository.lookupClass((String)clsName);
                if (cls.implementationOf(MAP_CLASS) && !name.endsWith("map")) {
                    return true;
                }
                if (cls.implementationOf(SET_CLASS) && !name.endsWith("set")) {
                    return true;
                }
                if (cls.implementationOf(LIST_CLASS) && !name.endsWith("list")) {
                    return true;
                }
                if (cls.implementationOf(QUEUE_CLASS) && !name.endsWith("queue")) {
                    return true;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        return false;
    }

    public void report() {
    }

    static {
        try {
            MAP_CLASS = Repository.lookupClass((String)"java/util/Map");
            SET_CLASS = Repository.lookupClass((String)"java/util/Set");
            LIST_CLASS = Repository.lookupClass((String)"java/util/List");
            QUEUE_CLASS = Repository.lookupClass((String)"java/util/Queue");
        }
        catch (ClassNotFoundException cnfe) {
            MAP_CLASS = null;
            SET_CLASS = null;
            LIST_CLASS = null;
            QUEUE_CLASS = null;
        }
    }
}

