/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariableTable;

public class CommonsEqualsBuilderToEquals
extends BytecodeScanningDetector {
    private static final String LANG_EQUALS_BUILDER = "Lorg/apache/commons/lang/builder/EqualsBuilder;";
    private static final String LANG3_EQUALS_BUILDER = "Lorg/apache/commons/lang3/builder/EqualsBuilder;";
    private final OpcodeStack stack = new OpcodeStack();
    private final BugReporter bugReporter;

    public CommonsEqualsBuilderToEquals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        String calledClass;
        String methodName;
        if (seen == 182 && "equals".equals(methodName = this.getNameConstantOperand()) && "(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() > 1 && (LANG3_EQUALS_BUILDER.equals(calledClass = this.stack.getStackItem(1).getSignature()) || LANG_EQUALS_BUILDER.equals(calledClass))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CEBE_COMMONS_EQUALS_BUILDER_ISEQUALS.name(), 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        super.sawOpcode(seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

