/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.objectweb.asm.Type;

@OpcodeStack.CustomUserValue
public class ConflatingResourcesAndFiles
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public ConflatingResourcesAndFiles(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean sawResource = false;
        try {
            String clsName;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182) {
                String methodName;
                clsName = this.getClassConstantOperand();
                if ("java/lang/Class".equals(clsName)) {
                    String methodName2 = this.getNameConstantOperand();
                    if ("getResource".equals(methodName2)) {
                        sawResource = true;
                    }
                } else if ("java/net/URL".equals(clsName) && ("toURI".equals(methodName = this.getNameConstantOperand()) || "getFile".equals(methodName)) && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getUserValue() != null) {
                    sawResource = true;
                }
            } else if (seen == 183) {
                clsName = this.getClassConstantOperand();
                if ("java/io/File".equals(clsName)) {
                    OpcodeStack.Item item;
                    String methodName = this.getNameConstantOperand();
                    String sig = this.getSigConstantOperand();
                    if ("<init>".equals(methodName) && Type.getArgumentTypes((String)sig).length == 1 && this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getUserValue() != null) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CRF_CONFLATING_RESOURCES_AND_FILES.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("java/net/URI".equals(clsName) || "java/net/URL".equals(clsName)) {
                    OpcodeStack.Item item;
                    String cons;
                    String methodName = this.getNameConstantOperand();
                    String sig = this.getSigConstantOperand();
                    if ("<init>".equals(methodName) && "(Ljava/lang/String;)V".equals(sig) && this.stack.getStackDepth() > 0 && (cons = (String)(item = this.stack.getStackItem(0)).getConstant()) != null && !cons.startsWith("file:/")) {
                        sawResource = true;
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (sawResource && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }
}

