/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class ConflictingTimeUnits
extends BytecodeScanningDetector {
    private static final Map<FQMethod, Units> TIME_UNIT_GENERATING_METHODS;
    private static final Map<String, Units> TIMEUNIT_TO_UNITS;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public ConflictingTimeUnits(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Units unit = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 184: 
                case 185: {
                    String signature = this.getSigConstantOperand();
                    FQMethod methodCall = new FQMethod(this.getClassConstantOperand(), this.getNameConstantOperand(), signature);
                    unit = TIME_UNIT_GENERATING_METHODS.get(methodCall);
                    if (unit != Units.CALLER) return;
                    int offset = Type.getArgumentTypes((String)signature).length;
                    if (this.stack.getStackDepth() > offset) {
                        OpcodeStack.Item item = this.stack.getStackItem(offset);
                        unit = (Units)((Object)item.getUserValue());
                        return;
                    }
                    unit = null;
                    return;
                }
                case 178: {
                    String clsName = this.getClassConstantOperand();
                    if (!"java/util/concurrent/TimeUnit".equals(clsName)) {
                        if (!"edu/emory/matchcs/backport/java/util/concurrent/TimeUnit".equals(clsName)) return;
                    }
                    unit = TIMEUNIT_TO_UNITS.get(this.getNameConstantOperand());
                    return;
                }
                case 133: 
                case 136: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    unit = (Units)((Object)item.getUserValue());
                    return;
                }
                case 96: 
                case 97: 
                case 100: 
                case 101: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 112: 
                case 113: {
                    if (this.stack.getStackDepth() <= 1) return;
                    OpcodeStack.Item arg1 = this.stack.getStackItem(0);
                    OpcodeStack.Item arg2 = this.stack.getStackItem(1);
                    Units u1 = (Units)((Object)arg1.getUserValue());
                    Units u2 = (Units)((Object)arg2.getUserValue());
                    if (u1 == null) return;
                    if (u2 == null) return;
                    if (u1 == u2) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CTU_CONFLICTING_TIME_UNITS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(u1.toString()).addString(u2.toString()));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (unit != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)unit);
            }
        }
    }

    static {
        HashMap<FQMethod, Units> tugm = new HashMap<FQMethod, Units>(50);
        tugm.put(new FQMethod("java/lang/System", "currentTimeMillis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/lang/System", "nanoTime", "()J"), Units.NANOS);
        tugm.put(new FQMethod("java/sql/Timestamp", "getTime", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/sql/Timestamp", "getNanos", "()I"), Units.NANOS);
        tugm.put(new FQMethod("java/util/Date", "getTime", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toNanos", "(J)J"), Units.NANOS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toMicros", "(J)J"), Units.MICROS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toSeconds", "(J)J"), Units.SECONDS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toMinutes", "(J)J"), Units.MINUTES);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toHours", "(J)J"), Units.HOURS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "toDays", "(J)J"), Units.DAYS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "excessNanos", "(JJ)I"), Units.NANOS);
        tugm.put(new FQMethod("java/util/concurrent/TimeUnit", "convert", "(JLjava/util/concurrent/TimeUnit;)J"), Units.CALLER);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toNanos", "(J)J"), Units.NANOS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toMicros", "(J)J"), Units.MICROS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toSeconds", "(J)J"), Units.SECONDS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toMinutes", "(J)J"), Units.MINUTES);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toHours", "(J)J"), Units.HOURS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "toDays", "(J)J"), Units.DAYS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "excessNanos", "(JJ)I"), Units.NANOS);
        tugm.put(new FQMethod("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit", "convert", "(JLjava/util/concurrent/TimeUnit;)J"), Units.CALLER);
        tugm.put(new FQMethod("org/joda/time/base/BaseDuration", "getMillis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("org/joda/time/base/BaseInterval", "getEndMillis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("org/joda/time/base/BaseInterval", "getStartMillis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/time/Clock", "millis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/time/Duration", "getNano", "()I"), Units.NANOS);
        tugm.put(new FQMethod("java/time/Duration", "getSeconds", "()J"), Units.SECONDS);
        tugm.put(new FQMethod("java/time/Duration", "toDays", "()J"), Units.DAYS);
        tugm.put(new FQMethod("java/time/Duration", "toHours", "()J"), Units.HOURS);
        tugm.put(new FQMethod("java/time/Duration", "toMillis", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/time/Duration", "toSeconds", "()J"), Units.SECONDS);
        tugm.put(new FQMethod("java/time/Duration", "toNanos", "()J"), Units.NANOS);
        tugm.put(new FQMethod("java/time/Instant", "getNano", "()I"), Units.NANOS);
        tugm.put(new FQMethod("java/time/Instant", "toEpochMmilli", "()J"), Units.MILLIS);
        tugm.put(new FQMethod("java/time/LocalDate", "getDayOfMonth", "()I"), Units.DAYS);
        tugm.put(new FQMethod("java/time/LocalDate", "getDayOfYear", "()I"), Units.DAYS);
        tugm.put(new FQMethod("java/time/LocalDate", "getEpochDay", "()J"), Units.DAYS);
        tugm.put(new FQMethod("java/time/LocalDateTime", "getDayOfMonth", "()J"), Units.DAYS);
        tugm.put(new FQMethod("java/time/LocalDateTime", "getDayOfYear", "()I"), Units.DAYS);
        tugm.put(new FQMethod("java/time/LocalDateTime", "getHour", "()I"), Units.HOURS);
        tugm.put(new FQMethod("java/time/LocalDateTime", "getNano", "()I"), Units.NANOS);
        tugm.put(new FQMethod("java/time/LocalDateTime", "getSecond", "()I"), Units.SECONDS);
        tugm.put(new FQMethod("java/time/LocalTime", "getHour", "()I"), Units.HOURS);
        tugm.put(new FQMethod("java/time/LocalTime", "getMinute", "()I"), Units.MINUTES);
        tugm.put(new FQMethod("java/time/LocalTime", "getNano", "()I"), Units.NANOS);
        tugm.put(new FQMethod("java/time/LocalTime", "getSecond", "()I"), Units.SECONDS);
        tugm.put(new FQMethod("java/time/LocalTime", "toNanoOfDay", "()J"), Units.NANOS);
        tugm.put(new FQMethod("java/time/LocalTime", "toSecondOfDay", "()I"), Units.SECONDS);
        TIME_UNIT_GENERATING_METHODS = Collections.unmodifiableMap(tugm);
        HashMap<String, Units> tutu = new HashMap<String, Units>();
        tutu.put("NANOSECONDS", Units.NANOS);
        tutu.put("MICROSECONDS", Units.MICROS);
        tutu.put("MILLISECONDS", Units.MILLIS);
        tutu.put("SECONDS", Units.SECONDS);
        tutu.put("MINUTES", Units.MINUTES);
        tutu.put("HOURS", Units.HOURS);
        tutu.put("DAYS", Units.DAYS);
        TIMEUNIT_TO_UNITS = Collections.unmodifiableMap(tutu);
    }

    private static enum Units {
        NANOS,
        MICROS,
        MILLIS,
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        CALLER;

    }
}

