/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class ConfusingAutoboxedOverloading
extends PreorderVisitor
implements Detector {
    private static final int JDK15_MAJOR = 49;
    private static final Set<String> primitiveSigs;
    private final BugReporter bugReporter;

    public ConfusingAutoboxedOverloading(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (cls.isClass() && cls.getMajor() >= 49) {
            Method[] methods;
            HashMap<String, Set<String>> methodInfo = new HashMap<String, Set<String>>();
            this.populateMethodInfo(cls, methodInfo);
            for (Method m : methods = cls.getMethods()) {
                String name = m.getName();
                String signature = m.getSignature();
                Set sigs = (Set)methodInfo.get(name);
                if (sigs == null) continue;
                for (String sig : sigs) {
                    if (!ConfusingAutoboxedOverloading.confusingSignatures(sig, signature)) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CAO_CONFUSING_AUTOBOXED_OVERLOADING.name(), 2).addClass(cls.getClassName()).addString(name + signature).addString(name + sig));
                }
            }
        }
    }

    private static boolean confusingSignatures(String sig1, String sig2) {
        Type[] type2;
        if (sig1.equals(sig2)) {
            return false;
        }
        Type[] type1 = Type.getArgumentTypes((String)sig1);
        if (type1.length != (type2 = Type.getArgumentTypes((String)sig2)).length) {
            return false;
        }
        boolean foundParmDiff = false;
        for (int i = 0; i < type1.length; ++i) {
            String typeTwoSig;
            String typeOneSig = type1[i].getSignature();
            if (typeOneSig.equals(typeTwoSig = type2[i].getSignature())) continue;
            if ("Ljava/lang/Character;".equals(typeOneSig)) {
                if (!primitiveSigs.contains(typeTwoSig)) {
                    return false;
                }
            } else if ("Ljava/lang/Character;".equals(typeTwoSig)) {
                if (!primitiveSigs.contains(typeOneSig)) {
                    return false;
                }
            } else {
                return false;
            }
            foundParmDiff = true;
        }
        return foundParmDiff;
    }

    private void populateMethodInfo(JavaClass cls, Map<String, Set<String>> methodInfo) {
        try {
            Method[] methods;
            if ("java.lang.Object".equals(cls.getClassName())) {
                return;
            }
            for (Method m : methods = cls.getMethods()) {
                String sig = m.getSignature();
                if (!ConfusingAutoboxedOverloading.isPossiblyConfusingSignature(sig)) continue;
                String name = m.getName();
                Set<String> sigs = methodInfo.get(name);
                if (sigs == null) {
                    sigs = new HashSet<String>(3);
                    methodInfo.put(name, sigs);
                }
                sigs.add(m.getSignature());
            }
            this.populateMethodInfo(cls.getSuperClass(), methodInfo);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private static boolean isPossiblyConfusingSignature(String sig) {
        Type[] types;
        for (Type t : types = Type.getArgumentTypes((String)sig)) {
            sig = t.getSignature();
            if (!primitiveSigs.contains(sig) && !"Ljava/lang/Character;".equals(sig)) continue;
            return true;
        }
        return false;
    }

    public void report() {
    }

    static {
        HashSet<String> ps = new HashSet<String>();
        ps.add("I");
        ps.add("J");
        ps.add("D");
        ps.add("F");
        primitiveSigs = Collections.unmodifiableSet(ps);
    }
}

