/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ConstantListIndex
extends BytecodeScanningDetector {
    private static final String MAX_ICONST0_LOOP_DISTANCE_PROPERTY = "fb-contrib.cli.maxloopdistance";
    private static final Set<FQMethod> ubiquitousMethods;
    private static JavaClass INVOCATIONHANDLER_CLASS;
    private final BugReporter bugReporter;
    private State state;
    private BitSet iConst0Looped;
    private final int max_iConst0LoopDistance;
    private OpcodeStack stack;

    public ConstantListIndex(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.max_iConst0LoopDistance = Integer.getInteger(MAX_ICONST0_LOOP_DISTANCE_PROPERTY, 30);
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            if (INVOCATIONHANDLER_CLASS != null && classContext.getJavaClass().implementationOf(INVOCATIONHANDLER_CLASS)) {
                return;
            }
            this.iConst0Looped = new BitSet();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.iConst0Looped = null;
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.state = State.SAW_NOTHING;
        this.iConst0Looped.clear();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (this.state) {
                case SAW_NOTHING: {
                    Constant c;
                    if (seen == 3) {
                        this.state = State.SAW_CONSTANT_0;
                        break;
                    }
                    if (seen >= 4 && seen <= 8) {
                        this.state = State.SAW_CONSTANT;
                        break;
                    }
                    if (seen != 18 && seen != 19 || !((c = this.getConstantRefOperand()) instanceof ConstantInteger)) break;
                    this.state = State.SAW_CONSTANT;
                    break;
                }
                case SAW_CONSTANT_0: 
                case SAW_CONSTANT: {
                    switch (seen) {
                        case 50: {
                            if ("main".equals(this.getMethodName())) break;
                        }
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 53: {
                            OpcodeStack.Item item;
                            if (this.stack.getStackDepth() <= 1 || ConstantListIndex.isArrayFromUbiquitousMethod(item = this.stack.getStackItem(1))) break;
                            if (this.state == State.SAW_CONSTANT_0) {
                                this.iConst0Looped.set(this.getPC());
                                break;
                            }
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CLI_CONSTANT_LIST_INDEX.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case 182: {
                            String methodName;
                            if (!"java/util/List".equals(this.getClassConstantOperand()) || !"get".equals(methodName = this.getNameConstantOperand())) break;
                            if (this.state == State.SAW_CONSTANT_0) {
                                this.iConst0Looped.set(this.getPC());
                                break;
                            }
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CLI_CONSTANT_LIST_INDEX.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                    }
                    this.state = State.SAW_NOTHING;
                }
            }
            if (seen >= 153 && seen <= 167 || seen == 200) {
                int branchTarget = this.getBranchTarget();
                int bugPC = this.iConst0Looped.nextSetBit(0);
                while (bugPC >= 0) {
                    if (branchTarget < bugPC) {
                        if (bugPC - branchTarget < this.max_iConst0LoopDistance) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CLI_CONSTANT_LIST_INDEX.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, bugPC));
                        }
                        this.iConst0Looped.clear(bugPC);
                    }
                    bugPC = this.iConst0Looped.nextSetBit(bugPC + 1);
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static boolean isArrayFromUbiquitousMethod(OpcodeStack.Item item) {
        XMethod method = item.getReturnValueOf();
        if (method == null) {
            return false;
        }
        FQMethod methodDesc = new FQMethod(method.getClassName(), method.getName(), method.getSignature());
        return ubiquitousMethods.contains(methodDesc);
    }

    static {
        HashSet<FQMethod> um = new HashSet<FQMethod>();
        um.add(new FQMethod("java.lang.String", "split", "(Ljava/lang/String;)[Ljava/lang/String;"));
        um.add(new FQMethod("java.lang.String", "split", "(Ljava/lang/String;I)[Ljava/lang/String;"));
        ubiquitousMethods = Collections.unmodifiableSet(um);
        try {
            INVOCATIONHANDLER_CLASS = Repository.lookupClass((String)"java/lang/reflect/InvocationHandler");
        }
        catch (ClassNotFoundException cnfe) {
            INVOCATIONHANDLER_CLASS = null;
        }
    }

    static enum State {
        SAW_NOTHING,
        SAW_CONSTANT_0,
        SAW_CONSTANT;

    }
}

