/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;

public class ContainsBasedConditional
extends BytecodeScanningDetector {
    private static final int LOW_CONDITIONAL_COUNT = 3;
    private static final int NORMAL_CONDITIONAL_COUNT = 4;
    private static final int HIGH_CONDITIONAL_COUNT = 6;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private List<Integer> switchLocs;
    private State state;
    private int loadType;
    private String constType;
    private int conditionCount;
    private int bugPC;

    public ContainsBasedConditional(BugReporter reporter) {
        this.bugReporter = reporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.switchLocs = new ArrayList<Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.switchLocs = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.state = State.SAW_NOTHING;
        this.loadType = 0;
        this.constType = null;
        this.conditionCount = 0;
        this.bugPC = 0;
        this.switchLocs.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="This fall-through is deliberate and documented")
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 171 || seen == 170) {
                this.switchLocs.add(this.getPC());
                for (int offset : this.getSwitchOffsets()) {
                    this.switchLocs.add(this.getPC() + offset);
                }
            }
            if (!this.switchLocs.isEmpty() && this.getPC() == this.switchLocs.get(0).intValue()) {
                this.state = State.SAW_NOTHING;
                this.switchLocs.remove(0);
                return;
            }
            switch (this.state) {
                case SAW_NOTHING: {
                    this.conditionCount = 0;
                }
                case SAW_PATTERN: {
                    if (ContainsBasedConditional.isLoad(seen)) {
                        if (this.conditionCount > 0) {
                            if (this.loadType == seen) {
                                this.state = State.SAW_LOAD;
                                return;
                            } else {
                                this.state = State.SAW_NOTHING;
                                return;
                            }
                        } else {
                            this.loadType = seen;
                            this.bugPC = this.getPC();
                            this.state = State.SAW_LOAD;
                            return;
                        }
                    } else {
                        if (this.conditionCount < 3) return;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CBC_CONTAINS_BASED_CONDITIONAL.name(), ContainsBasedConditional.priority(this.conditionCount)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.bugPC));
                        return;
                    }
                }
                case SAW_LOAD: {
                    if (seen == 18 || seen == 19) {
                        Constant c = this.getConstantRefOperand();
                        String currConstType = null;
                        if (c instanceof ConstantString) {
                            currConstType = "java/lang/String";
                        } else if (c instanceof ConstantClass) {
                            currConstType = "java/lang/Class";
                        }
                        if (this.conditionCount > 0) {
                            if (this.constType != null && this.constType.equals(currConstType)) {
                                this.state = State.SAW_CONST;
                                return;
                            } else {
                                this.state = State.SAW_NOTHING;
                                return;
                            }
                        } else if (currConstType != null) {
                            this.state = State.SAW_CONST;
                            this.constType = currConstType;
                            return;
                        } else {
                            this.state = State.SAW_NOTHING;
                            return;
                        }
                    } else if (seen == 178) {
                        this.state = State.SAW_CONST;
                        return;
                    } else if (seen >= 2 && seen <= 8) {
                        this.state = State.SAW_CONST;
                        return;
                    } else if (seen >= 9 && seen <= 10) {
                        this.state = State.SAW_CONST;
                        return;
                    } else {
                        this.state = State.SAW_NOTHING;
                        return;
                    }
                }
                case SAW_CONST: {
                    if (seen == 182 && "equals".equals(this.getNameConstantOperand()) && "(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand())) {
                        this.state = State.SAW_EQUALS;
                        return;
                    } else if (seen == 159) {
                        ++this.conditionCount;
                        this.state = State.SAW_PATTERN;
                        return;
                    } else if (seen == 160) {
                        ++this.conditionCount;
                        if (this.conditionCount >= 3) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CBC_CONTAINS_BASED_CONDITIONAL.name(), ContainsBasedConditional.priority(this.conditionCount)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.bugPC));
                        }
                        this.state = State.SAW_NOTHING;
                        return;
                    } else {
                        this.state = State.SAW_NOTHING;
                        return;
                    }
                }
                case SAW_EQUALS: {
                    if (seen == 154) {
                        ++this.conditionCount;
                        this.state = State.SAW_PATTERN;
                        return;
                    } else if (seen == 153) {
                        ++this.conditionCount;
                        if (this.conditionCount >= 3) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CBC_CONTAINS_BASED_CONDITIONAL.name(), this.conditionCount < 4 ? 3 : (this.conditionCount < 6 ? 2 : 1)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.bugPC));
                        }
                        this.state = State.SAW_NOTHING;
                        return;
                    } else {
                        this.state = State.SAW_NOTHING;
                        return;
                    }
                }
                default: {
                    throw new AssertionError((Object)("Unhandled state: " + (Object)((Object)this.state)));
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static boolean isLoad(int seen) {
        return OpcodeUtils.isALoad(seen) || OpcodeUtils.isILoad(seen) || OpcodeUtils.isLLoad(seen);
    }

    private static int priority(int conditionCount) {
        return conditionCount < 4 ? 3 : (conditionCount < 6 ? 2 : 1);
    }

    private static enum State {
        SAW_NOTHING,
        SAW_LOAD,
        SAW_CONST,
        SAW_EQUALS,
        SAW_PATTERN;

    }
}

