/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class ContraVariantArrayAssignment
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private final OpcodeStack stack;

    public ContraVariantArrayAssignment(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.stack = new OpcodeStack();
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    LocalVariable lv;
                    if (this.stack.getStackDepth() <= 0 || (lv = this.getMethod().getLocalVariableTable().getLocalVariable(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen), this.getNextPC())) == null) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String sourceSignature = item.getSignature();
                    String targetSignature = lv.getSignature();
                    this.checkSignatures(sourceSignature, targetSignature);
                    break;
                }
                case 179: 
                case 181: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String sourceSignature = item.getSignature();
                    String targetSignature = this.getSigConstantOperand();
                    this.checkSignatures(sourceSignature, targetSignature);
                    break;
                }
            }
            super.sawOpcode(seen);
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static boolean isArrayType(String signature) {
        return Type.getType((String)signature) instanceof ArrayType;
    }

    private static boolean isObjectType(String signature) {
        return ((ArrayType)Type.getType((String)signature)).getBasicType() instanceof ObjectType;
    }

    private void checkSignatures(String sourceSignature, String targetSignature) {
        try {
            if ("Ljava/lang/Object;".equals(targetSignature)) {
                return;
            }
            if (ContraVariantArrayAssignment.isArrayType(sourceSignature) && ContraVariantArrayAssignment.isArrayType(targetSignature) && ContraVariantArrayAssignment.isObjectType(sourceSignature) && ContraVariantArrayAssignment.isObjectType(targetSignature)) {
                ObjectType sourceType = (ObjectType)((ArrayType)Type.getType((String)sourceSignature)).getBasicType();
                ObjectType targetType = (ObjectType)((ArrayType)Type.getType((String)targetSignature)).getBasicType();
                if (!targetType.equals((Object)sourceType) && !targetType.subclassOf(sourceType)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CVAA_CONTRAVARIANT_ELEMENT_ASSIGNMENT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }
}

