/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class CopiedOverriddenMethod
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private Map<String, CodeInfo> superclassCode;
    private ClassContext classContext;
    private String curMethodInfo;
    private ConstantPoolGen childPoolGen;
    private ConstantPoolGen parentPoolGen;
    private Type[] parmTypes;
    private int nextParmIndex;
    private int nextParmOffset;
    private boolean sawAload0;
    private boolean sawParentCall;
    private boolean ignore;

    public CopiedOverriddenMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext clsContext) {
        try {
            JavaClass cls = clsContext.getJavaClass();
            String superName = cls.getSuperclassName();
            if (!"java.lang.Object".equals(superName)) {
                Method[] methods;
                this.classContext = clsContext;
                this.superclassCode = new HashMap<String, CodeInfo>();
                JavaClass superCls = cls.getSuperClass();
                this.childPoolGen = new ConstantPoolGen(cls.getConstantPool());
                this.parentPoolGen = new ConstantPoolGen(superCls.getConstantPool());
                for (Method m : methods = superCls.getMethods()) {
                    String methodName = m.getName();
                    if (!m.isPublic() && !m.isProtected() || m.isAbstract() || m.isSynthetic() || "<init>".equals(methodName) || "<clinit>".equals(methodName)) continue;
                    String methodInfo = methodName + ':' + m.getSignature();
                    this.superclassCode.put(methodInfo, new CodeInfo(m.getCode(), m.getAccessFlags()));
                }
                cls.accept((Visitor)this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.superclassCode = null;
            this.classContext = null;
            this.childPoolGen = null;
            this.parentPoolGen = null;
        }
    }

    public void visitMethod(Method obj) {
        this.curMethodInfo = obj.getName() + ':' + obj.getSignature();
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (!m.isPublic() && !m.isProtected() && !m.isAbstract() || m.isSynthetic()) {
            return;
        }
        CodeInfo superCode = this.superclassCode.remove(this.curMethodInfo);
        if (superCode != null) {
            if (CopiedOverriddenMethod.sameAccess(this.getMethod().getAccessFlags(), superCode.getAccess()) && this.codeEquals(obj, superCode.getCode())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.COM_COPIED_OVERRIDDEN_METHOD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(this.classContext, (PreorderVisitor)this, this.getPC()));
                return;
            }
            this.parmTypes = this.getMethod().getArgumentTypes();
            this.ignore = false;
            this.nextParmIndex = 0;
            this.nextParmOffset = (this.getMethod().getAccessFlags() & 8) != 0 ? 0 : 1;
            this.sawAload0 = this.nextParmOffset == 0;
            this.sawParentCall = false;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (this.ignore) {
            return;
        }
        if (!this.sawAload0) {
            if (seen == 42) {
                this.sawAload0 = true;
            } else {
                this.ignore = true;
            }
        } else if (this.nextParmIndex < this.parmTypes.length) {
            if (this.isExpectedParmInstruction(seen, this.nextParmOffset, this.parmTypes[this.nextParmIndex])) {
                this.nextParmOffset += SignatureUtils.getSignatureSize(this.parmTypes[this.nextParmIndex].getSignature());
                ++this.nextParmIndex;
            } else {
                this.ignore = true;
            }
        } else if (!this.sawParentCall) {
            if (seen == 183 && this.getNameConstantOperand().equals(this.getMethod().getName()) && this.getSigConstantOperand().equals(this.getMethod().getSignature())) {
                this.sawParentCall = true;
            } else {
                this.ignore = true;
            }
        } else {
            int expectedInstruction = CopiedOverriddenMethod.getExpectedReturnInstruction(this.getMethod().getReturnType());
            if (seen == expectedInstruction && this.getNextPC() == this.getCode().getCode().length) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.COM_PARENT_DELEGATED_CALL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else {
                this.ignore = true;
            }
        }
    }

    private boolean isExpectedParmInstruction(int seen, int parmOffset, Type type) {
        if (type == Type.OBJECT || type == Type.STRING || type == Type.STRINGBUFFER || type == Type.THROWABLE) {
            if (parmOffset <= 3) {
                return 42 + parmOffset == seen;
            }
            return 25 == seen && parmOffset == this.getRegisterOperand();
        }
        if (type == Type.DOUBLE) {
            if (parmOffset <= 3) {
                return 38 + parmOffset == seen;
            }
            return 24 == seen && parmOffset == this.getRegisterOperand();
        }
        if (type == Type.FLOAT) {
            if (parmOffset <= 3) {
                return 34 + parmOffset == seen;
            }
            return 23 == seen && parmOffset == this.getRegisterOperand();
        }
        if (type == Type.LONG) {
            if (parmOffset <= 3) {
                return 30 + parmOffset == seen;
            }
            return 22 == seen && parmOffset == this.getRegisterOperand();
        }
        if (parmOffset <= 3) {
            return 26 + parmOffset == seen;
        }
        return 21 == seen && parmOffset == this.getRegisterOperand();
    }

    private static int getExpectedReturnInstruction(Type type) {
        if (type == Type.OBJECT || type == Type.STRING || type == Type.STRINGBUFFER || type == Type.THROWABLE) {
            return 176;
        }
        if (type == Type.DOUBLE) {
            return 175;
        }
        if (type == Type.FLOAT) {
            return 174;
        }
        if (type == Type.LONG) {
            return 173;
        }
        return 172;
    }

    private static boolean sameAccess(int parentAccess, int childAccess) {
        return (parentAccess & 5) == (childAccess & 5);
    }

    private boolean codeEquals(Code child, Code parent) {
        InstructionHandle[] parentihs;
        byte[] childBytes = child.getCode();
        byte[] parentBytes = parent.getCode();
        if (childBytes == null || parentBytes == null) {
            return false;
        }
        if (childBytes.length != parentBytes.length) {
            return false;
        }
        InstructionHandle[] childihs = new InstructionList(childBytes).getInstructionHandles();
        if (childihs.length != (parentihs = new InstructionList(parentBytes).getInstructionHandles()).length) {
            return false;
        }
        for (int i = 0; i < childihs.length; ++i) {
            InstructionHandle childih = childihs[i];
            InstructionHandle parentih = parentihs[i];
            Instruction childin = childih.getInstruction();
            Instruction parentin = parentih.getInstruction();
            if (!childin.getName().equals(parentin.getName())) {
                return false;
            }
            if (childin instanceof FieldInstruction) {
                String parentFSig;
                String parentFName;
                String childFName = ((FieldInstruction)childin).getFieldName(this.childPoolGen);
                if (!childFName.equals(parentFName = ((FieldInstruction)parentin).getFieldName(this.parentPoolGen))) {
                    return false;
                }
                String childFSig = ((FieldInstruction)childin).getSignature(this.childPoolGen);
                if (!childFSig.equals(parentFSig = ((FieldInstruction)parentin).getSignature(this.parentPoolGen))) {
                    return false;
                }
                if (childFSig.charAt(0) != 'L') continue;
                ReferenceType childRefType = ((FieldInstruction)childin).getReferenceType(this.childPoolGen);
                ReferenceType parentRefType = ((FieldInstruction)parentin).getReferenceType(this.parentPoolGen);
                if (childRefType.getSignature().equals(parentRefType.getSignature())) continue;
                return false;
            }
            if (childin instanceof InvokeInstruction) {
                String parentSignature;
                String parentMethodName;
                String parentClassName;
                String childClassName = ((InvokeInstruction)childin).getClassName(this.childPoolGen);
                if (!childClassName.equals(parentClassName = ((InvokeInstruction)parentin).getClassName(this.parentPoolGen))) {
                    return false;
                }
                String childMethodName = ((InvokeInstruction)childin).getMethodName(this.childPoolGen);
                if (!childMethodName.equals(parentMethodName = ((InvokeInstruction)parentin).getMethodName(this.parentPoolGen))) {
                    return false;
                }
                String childSignature = ((InvokeInstruction)childin).getSignature(this.childPoolGen);
                if (childSignature.equals(parentSignature = ((InvokeInstruction)parentin).getSignature(this.parentPoolGen))) continue;
                return false;
            }
            if (childin instanceof LDC) {
                Type parentType;
                Type childType = ((LDC)childin).getType(this.childPoolGen);
                if (!childType.equals((Object)(parentType = ((LDC)parentin).getType(this.parentPoolGen)))) {
                    return false;
                }
                Object childValue = ((LDC)childin).getValue(this.childPoolGen);
                Object parentValue = ((LDC)parentin).getValue(this.parentPoolGen);
                if (childValue instanceof ConstantClass) {
                    ConstantClass childClass = (ConstantClass)childValue;
                    ConstantClass parentClass = (ConstantClass)parentValue;
                    if (childClass.getBytes(this.childPoolGen.getConstantPool()).equals(parentClass.getBytes(this.parentPoolGen.getConstantPool()))) continue;
                    return false;
                }
                if (childValue.equals(parentValue)) continue;
                return false;
            }
            if (childin.equals((Object)parentin)) continue;
            return false;
        }
        return true;
    }

    static class CodeInfo {
        private Code code;
        private int access;

        public CodeInfo(Code c, int acc) {
            this.code = c;
            this.access = acc;
        }

        public Code getCode() {
            return this.code;
        }

        public int getAccess() {
            return this.access;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

