/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class CyclomaticComplexity
extends PreorderVisitor
implements Detector {
    public static final String LIMIT_PROPERTY = "fb-contrib.cc.limit";
    private BugReporter bugReporter;
    private ClassContext classContext;
    private int reportLimit = 50;

    public CyclomaticComplexity(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        Integer limit = Integer.getInteger(LIMIT_PROPERTY);
        if (limit != null) {
            this.reportLimit = limit;
        }
    }

    public void visitClassContext(ClassContext context) {
        try {
            this.classContext = context;
            this.classContext.getJavaClass().accept((Visitor)this);
        }
        finally {
            this.classContext = null;
        }
    }

    public void report() {
    }

    public void visitMethod(Method obj) {
        try {
            if ((obj.getAccessFlags() & 0x1000) != 0) {
                return;
            }
            Code code = obj.getCode();
            if (code == null) {
                return;
            }
            if (code.getCode().length < 2 * this.reportLimit) {
                return;
            }
            BitSet exceptionNodeTargets = new BitSet();
            CFG cfg = this.classContext.getCFG(obj);
            int branches = 0;
            Iterator bbi = cfg.blockIterator();
            while (bbi.hasNext()) {
                BasicBlock bb = (BasicBlock)bbi.next();
                Iterator iei = cfg.outgoingEdgeIterator((AbstractVertex)bb);
                while (iei.hasNext()) {
                    Edge e = (Edge)iei.next();
                    int edgeType = e.getType();
                    if (edgeType == 0 || edgeType == 7 || edgeType == -1) continue;
                    if (edgeType == 8 || edgeType == 9) {
                        int nodeTarget = ((BasicBlock)e.getTarget()).getLabel();
                        if (exceptionNodeTargets.get(nodeTarget)) continue;
                        exceptionNodeTargets.set(nodeTarget);
                        ++branches;
                        continue;
                    }
                    ++branches;
                }
            }
            if (branches > this.reportLimit) {
                int priority = branches > this.reportLimit * 2 ? 1 : 2;
                BugInstance bug = new BugInstance((Detector)this, BugType.CC_CYCLOMATIC_COMPLEXITY.name(), priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(this.classContext, (PreorderVisitor)this, 0).addInt(branches);
                this.bugReporter.reportBug(bug);
            }
        }
        catch (CFGBuilderException cbe) {
            this.bugReporter.logError("Failure examining basic blocks for method " + this.classContext.getJavaClass().getClassName() + '.' + obj.getName() + " in Cyclomatic Complexity detector", (Throwable)cbe);
        }
    }
}

