/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.CodeByteUtils;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.QMethod;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class DeletingWhileIterating
extends BytecodeScanningDetector {
    private static JavaClass collectionClass;
    private static JavaClass iteratorClass;
    private static Set<JavaClass> exceptionClasses;
    private static final Set<QMethod> collectionMethods;
    private static final Map<QMethod, Integer> modifyingMethods;
    private static final QMethod ITERATOR;
    private static final QMethod REMOVE;
    private static final QMethod HASNEXT;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private List<GroupPair> collectionGroups;
    private Map<Integer, Integer> groupToIterator;
    private Map<Integer, Loop> loops;
    private Map<Integer, BitSet> endOfScopes;

    public DeletingWhileIterating(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (collectionClass == null || iteratorClass == null) {
            return;
        }
        try {
            this.stack = new OpcodeStack();
            this.collectionGroups = new ArrayList<GroupPair>();
            this.groupToIterator = new HashMap<Integer, Integer>();
            this.loops = new HashMap<Integer, Loop>(10);
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.collectionGroups = null;
            this.groupToIterator = null;
            this.loops = null;
            this.endOfScopes = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.collectionGroups.clear();
        this.groupToIterator.clear();
        this.loops.clear();
        this.buildVariableEndScopeMap();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block35: {
            int groupId = -1;
            try {
                OpcodeStack.Item itm;
                Integer id;
                this.stack.precomputation((DismantleBytecode)this);
                if (seen == 185) {
                    OpcodeStack.Item itm2;
                    Integer id2;
                    String className = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    QMethod methodInfo = new QMethod(methodName, signature);
                    if (this.isCollection(className)) {
                        if (collectionMethods.contains(methodInfo)) {
                            if (this.stack.getStackDepth() > 0) {
                                OpcodeStack.Item itm3 = this.stack.getStackItem(0);
                                groupId = this.findCollectionGroup(itm3, true);
                            }
                        } else if (ITERATOR.equals(methodInfo)) {
                            if (this.stack.getStackDepth() > 0) {
                                OpcodeStack.Item itm4 = this.stack.getStackItem(0);
                                groupId = this.findCollectionGroup(itm4, true);
                            }
                        } else if (REMOVE.equals(methodInfo)) {
                            int pc;
                            Integer it;
                            Loop loop;
                            OpcodeStack.Item itm5;
                            int id3;
                            if (this.stack.getStackDepth() > 1 && (id3 = this.findCollectionGroup(itm5 = this.stack.getStackItem(1), true)) >= 0 && this.collectionGroups.get(id3).isStandardCollection() && (loop = this.loops.get(it = this.groupToIterator.get(id3))) != null && loop.hasPC(pc = this.getPC())) {
                                boolean returnFollows;
                                boolean needPop = !"V".equals(Type.getReturnType((String)signature).getSignature());
                                boolean breakFollows = this.breakFollows(loop, needPop);
                                boolean bl = returnFollows = breakFollows ? false : this.returnFollows(needPop);
                                if (!breakFollows && !returnFollows) {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.DWI_DELETING_WHILE_ITERATING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                }
                            }
                        } else {
                            int pc;
                            Loop loop;
                            Integer it;
                            OpcodeStack.Item itm6;
                            int id4;
                            Integer numArgs = modifyingMethods.get(methodInfo);
                            if (numArgs != null && this.stack.getStackDepth() > numArgs && (id4 = this.findCollectionGroup(itm6 = this.stack.getStackItem(numArgs.intValue()), true)) >= 0 && (it = this.groupToIterator.get(id4)) != null && (loop = this.loops.get(it)) != null && loop.hasPC(pc = this.getPC())) {
                                boolean returnFollows;
                                boolean needPop = !"V".equals(Type.getReturnType((String)signature).getSignature());
                                boolean breakFollows = this.breakFollows(loop, needPop);
                                boolean bl = returnFollows = breakFollows ? false : this.returnFollows(needPop);
                                if (!breakFollows && !returnFollows) {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.DWI_MODIFYING_WHILE_ITERATING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                }
                            }
                        }
                    } else if ("java/util/Iterator".equals(className) && HASNEXT.equals(methodInfo) && this.stack.getStackDepth() > 0 && (id2 = (Integer)(itm2 = this.stack.getStackItem(0)).getUserValue()) != null) {
                        groupId = id2;
                    }
                    break block35;
                }
                if (seen == 181 || seen == 179) {
                    OpcodeStack.Item itm7;
                    Integer id5;
                    if (this.stack.getStackDepth() > 1 && (id5 = (Integer)(itm7 = this.stack.getStackItem(0)).getUserValue()) == null) {
                        FieldAnnotation fa = FieldAnnotation.fromFieldDescriptor((FieldDescriptor)new FieldDescriptor(this.getClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand(), false));
                        itm7 = new OpcodeStack.Item(itm7.getSignature(), fa, this.stack.getStackItem(1).getRegisterNumber());
                        this.removeFromCollectionGroup(itm7);
                        groupId = this.findCollectionGroup(itm7, true);
                    }
                    break block35;
                }
                if (OpcodeUtils.isAStore(seen)) {
                    if (this.stack.getStackDepth() <= 0) break block35;
                    OpcodeStack.Item itm8 = this.stack.getStackItem(0);
                    Integer id6 = (Integer)itm8.getUserValue();
                    if (id6 != null) {
                        int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        try {
                            GroupPair pair;
                            JavaClass cls = itm8.getJavaClass();
                            if (cls != null && cls.implementationOf(iteratorClass)) {
                                Integer regIt = reg;
                                Iterator<Integer> curIt = this.groupToIterator.values().iterator();
                                while (curIt.hasNext()) {
                                    if (!curIt.next().equals(regIt)) continue;
                                    curIt.remove();
                                }
                                this.groupToIterator.put(id6, regIt);
                            }
                            if ((pair = this.collectionGroups.get(id6)) != null) {
                                pair.addMember(Integer.valueOf(reg));
                            }
                            break block35;
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.bugReporter.reportMissingClass(cnfe);
                        }
                        break block35;
                    }
                    String cls = itm8.getSignature();
                    if (cls == null || !cls.startsWith("L") || !this.isCollection(cls = cls.substring(1, cls.length() - 1)) && !"java/util/Iterator".equals(cls)) break block35;
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    this.removeFromCollectionGroup(new OpcodeStack.Item(itm8, reg));
                    Iterator<Integer> it = this.groupToIterator.values().iterator();
                    while (it.hasNext()) {
                        if (it.next() != reg) continue;
                        it.remove();
                        break block35;
                    }
                    break block35;
                }
                if (OpcodeUtils.isALoad(seen)) {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    OpcodeStack.Item itm9 = new OpcodeStack.Item(new OpcodeStack.Item(), reg);
                    groupId = this.findCollectionGroup(itm9, false);
                } else if (seen == 153 && this.stack.getStackDepth() > 0 && (id = (Integer)(itm = this.stack.getStackItem(0)).getUserValue()) != null) {
                    Integer reg;
                    int target = this.getBranchTarget();
                    int gotoAddr = target - 3;
                    int ins = this.getCode().getCode()[gotoAddr];
                    if (ins < 0) {
                        ins = 256 + ins;
                    }
                    if ((ins == 167 || ins == 200) && (reg = this.groupToIterator.get(id)) != null) {
                        this.loops.put(reg, new Loop(this.getPC(), gotoAddr));
                    }
                }
            }
            finally {
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (groupId >= 0 && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    itm.setUserValue((Object)groupId);
                }
                this.processEndOfScopes(this.getPC());
            }
        }
    }

    private boolean breakFollows(Loop loop, boolean needsPop) {
        int target;
        int popOp;
        byte[] code = this.getCode().getCode();
        int nextPC = this.getNextPC();
        if (needsPop && (popOp = CodeByteUtils.getbyte(code, nextPC++)) != 87) {
            return false;
        }
        int gotoOp = CodeByteUtils.getbyte(code, nextPC);
        return (gotoOp == 167 || gotoOp == 200) && (target = nextPC + CodeByteUtils.getshort(code, nextPC + 1)) > loop.getLoopFinish();
    }

    private boolean returnFollows(boolean couldSeePop) {
        int nextOp;
        byte[] code = this.getCode().getCode();
        int nextPC = this.getNextPC();
        if ((nextOp = CodeByteUtils.getbyte(code, nextPC++)) >= 172 && nextOp <= 177) {
            return true;
        }
        if (couldSeePop && nextOp == 87 && (nextOp = CodeByteUtils.getbyte(code, nextPC++)) >= 172 && nextOp <= 177) {
            return true;
        }
        return (nextOp = CodeByteUtils.getbyte(code, nextPC++)) >= 172 && nextOp <= 177;
    }

    private boolean isCollection(String className) {
        try {
            JavaClass cls = Repository.lookupClass((String)className);
            return cls.implementationOf(collectionClass) && !exceptionClasses.contains(cls);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return false;
        }
    }

    private static Comparable<?> getGroupElement(OpcodeStack.Item itm) {
        Object groupElement = null;
        int reg = itm.getRegisterNumber();
        if (reg >= 0) {
            groupElement = reg;
        } else {
            int regLoad;
            XField field = itm.getXField();
            if (field != null && (regLoad = itm.getFieldLoadedFromRegister()) >= 0) {
                groupElement = field.getName() + ":{" + regLoad + '}';
            }
        }
        return groupElement;
    }

    private int findCollectionGroup(OpcodeStack.Item itm, boolean addIfNotFound) {
        Integer id = (Integer)itm.getUserValue();
        if (id != null) {
            return id;
        }
        Comparable<?> groupElement = DeletingWhileIterating.getGroupElement(itm);
        if (groupElement != null) {
            int numGroups = this.collectionGroups.size();
            for (int i = 0; i < numGroups; ++i) {
                GroupPair groupPair = this.collectionGroups.get(i);
                if (!groupPair.containsMember(groupElement)) continue;
                return i;
            }
            if (addIfNotFound) {
                GroupPair groupPair = new GroupPair(groupElement, itm.getSignature());
                this.collectionGroups.add(groupPair);
                return this.collectionGroups.size() - 1;
            }
        }
        return -1;
    }

    private void removeFromCollectionGroup(OpcodeStack.Item itm) {
        Comparable<?> groupElement = DeletingWhileIterating.getGroupElement(itm);
        if (groupElement != null) {
            for (GroupPair groupPair : this.collectionGroups) {
                if (!groupPair.containsMember(groupElement)) continue;
                groupPair.removeMember(groupElement);
                break;
            }
        }
    }

    private void buildVariableEndScopeMap() {
        this.endOfScopes = new HashMap<Integer, BitSet>();
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null) {
            int len = lvt.getLength();
            for (int i = 0; i < len; ++i) {
                LocalVariable lv = lvt.getLocalVariable(i);
                if (lv == null) continue;
                Integer endPC = lv.getStartPC() + lv.getLength();
                BitSet vars = this.endOfScopes.get(endPC);
                if (vars == null) {
                    vars = new BitSet();
                    this.endOfScopes.put(endPC, vars);
                }
                vars.set(lv.getIndex());
            }
        }
    }

    private void processEndOfScopes(Integer pc) {
        BitSet endVars = this.endOfScopes.get(pc);
        if (endVars != null) {
            int i = endVars.nextSetBit(0);
            while (i >= 0) {
                Integer v = i;
                for (GroupPair groupPair : this.collectionGroups) {
                    if (!groupPair.containsMember(v)) continue;
                    groupPair.removeMember(v);
                }
                Iterator<Object> it = this.groupToIterator.values().iterator();
                while (it.hasNext()) {
                    if (!v.equals(it.next())) continue;
                    it.remove();
                }
                i = endVars.nextSetBit(i + 1);
            }
        }
    }

    static {
        try {
            collectionClass = Repository.lookupClass((String)"java/util/Collection");
            iteratorClass = Repository.lookupClass((String)"java/util/Iterator");
        }
        catch (ClassNotFoundException cnfe) {
            collectionClass = null;
            iteratorClass = null;
        }
        try {
            exceptionClasses = new HashSet<JavaClass>(2);
            exceptionClasses.add(Repository.lookupClass((String)"java/util/concurrent/CopyOnWriteArrayList"));
            exceptionClasses.add(Repository.lookupClass((String)"java/util/concurrent/CopyOnWriteArraySet"));
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        collectionMethods = UnmodifiableSet.create(new QMethod("entrySet", "()Ljava/lang/Set;"), new QMethod("keySet", "()Ljava/lang/Set;"), new QMethod("values", "()Ljava/lang/Collection;"));
        HashMap<QMethod, Integer> mm = new HashMap<QMethod, Integer>();
        mm.put(new QMethod("add", "(Ljava/lang/Object;)Z"), Values.ONE);
        mm.put(new QMethod("addAll", "(Ljava/util/Collection;)Z"), Values.ONE);
        mm.put(new QMethod("addAll", "(ILjava/util/Collection;)Z"), Values.TWO);
        mm.put(new QMethod("clear", "()V"), Values.ZERO);
        mm.put(new QMethod("remove", "(I)Ljava/lang/Object;"), Values.ONE);
        mm.put(new QMethod("removeAll", "(Ljava/util/Collection;)Z"), Values.ONE);
        mm.put(new QMethod("retainAll", "(Ljava/util/Collection;)Z"), Values.ONE);
        modifyingMethods = Collections.unmodifiableMap(mm);
        ITERATOR = new QMethod("iterator", "()Ljava/util/Iterator;");
        REMOVE = new QMethod("remove", "(Ljava/lang/Object;)Z");
        HASNEXT = new QMethod("hasNext", "()Z");
    }

    static class GroupPair {
        private final Set<Comparable<?>> groupMembers = new HashSet();
        private final String colClass;

        public GroupPair(Comparable<?> member, String cls) {
            this.groupMembers.add(member);
            this.colClass = cls;
        }

        void addMember(Comparable<?> member) {
            this.groupMembers.add(member);
        }

        void removeMember(Comparable<?> member) {
            this.groupMembers.remove(member);
        }

        boolean containsMember(Comparable<?> member) {
            return this.groupMembers.contains(member);
        }

        boolean isStandardCollection() {
            return this.colClass == null || !this.colClass.contains("/concurrent/");
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static class Loop {
        public int loopStart;
        public int loopFinish;

        public Loop(int start, int finish) {
            this.loopStart = start;
            this.loopFinish = finish;
        }

        int getLoopFinish() {
            return this.loopFinish;
        }

        int getLoopStart() {
            return this.loopStart;
        }

        boolean hasPC(int pc) {
            return this.loopStart <= pc && pc <= this.loopFinish;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

