/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.QMethod;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class DubiousListCollection
extends BytecodeScanningDetector {
    private static final Set<QMethod> setMethods = UnmodifiableSet.create(new QMethod("contains", "(Ljava/lang/Object;)Z"), new QMethod("containsAll", "(Ljava/util/Collection;)Z"), new QMethod("remove", "(Ljava/lang/Object;)Ljava/lang/Object;"), new QMethod("removeAll", "(Ljava/util/Collection;)Z"), new QMethod("retainAll", "(Ljava/util/Collection;)Z"));
    private static final Set<QMethod> listMethods = UnmodifiableSet.create(new QMethod("add", "(ILjava/lang/Object;)V"), new QMethod("addAll", "(ILjava/util/Collection;)Z"), new QMethod("lastIndexOf", "(Ljava/lang/Object;)I"), new QMethod("remove", "(I)Ljava/lang/Object;"), new QMethod("set", "(ILjava/lang/Object;)Ljava/lang/Object;"), new QMethod("subList", "(II)Ljava/util/List;"), new QMethod("listIterator", "()Ljava/util/ListIterator;"), new QMethod("listIterator", "(I)Ljava/util/ListIterator;"));
    private final BugReporter bugReporter;
    private final OpcodeStack stack = new OpcodeStack();
    private final Map<String, FieldInfo> fieldsReported = new HashMap<String, FieldInfo>(10);

    public DubiousListCollection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Field[] flds;
        JavaClass cls = classContext.getJavaClass();
        for (Field f : flds = cls.getFields()) {
            String sig = f.getSignature();
            if (sig.charAt(0) != 'L' || !(sig = sig.substring(1, sig.length() - 1)).startsWith("java/util/") || !sig.endsWith("List")) continue;
            this.fieldsReported.put(f.getName(), new FieldInfo());
        }
        if (this.fieldsReported.size() > 0) {
            super.visitClassContext(classContext);
            this.reportBugs();
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item item;
            XField field;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 185) {
                String fieldName;
                FieldInfo fi;
                String signature;
                XField field2;
                String className = this.getClassConstantOperand();
                if (className.startsWith("java/util/") && className.endsWith("List") && (field2 = DubiousListCollection.getFieldFromStack(this.stack, signature = this.getSigConstantOperand())) != null && (fi = this.fieldsReported.get(fieldName = field2.getName())) != null) {
                    String methodName = this.getNameConstantOperand();
                    QMethod methodInfo = new QMethod(methodName, signature);
                    if (listMethods.contains(methodInfo)) {
                        this.fieldsReported.remove(fieldName);
                    } else if (setMethods.contains(methodInfo)) {
                        fi.addUse(this.getPC());
                    }
                }
            } else if (seen == 182) {
                XField field3;
                String className = this.getClassConstantOperand();
                if (className.startsWith("java/util/") && className.endsWith("List") && (field3 = DubiousListCollection.getFieldFromStack(this.stack, this.getSigConstantOperand())) != null) {
                    String fieldName = field3.getName();
                    this.fieldsReported.remove(fieldName);
                }
            } else if (seen == 176 && this.stack.getStackDepth() > 0 && (field = (item = this.stack.getStackItem(0)).getXField()) != null) {
                String fieldName = field.getName();
                this.fieldsReported.remove(fieldName);
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static XField getFieldFromStack(OpcodeStack stk, String signature) {
        int parmCount = Type.getArgumentTypes((String)signature).length;
        if (stk.getStackDepth() > parmCount) {
            OpcodeStack.Item itm = stk.getStackItem(parmCount);
            return itm.getXField();
        }
        return null;
    }

    private void reportBugs() {
        int major = this.getClassContext().getJavaClass().getMajor();
        for (Map.Entry<String, FieldInfo> entry : this.fieldsReported.entrySet()) {
            FieldAnnotation fa;
            String field = entry.getKey();
            FieldInfo fi = entry.getValue();
            int cnt = fi.getSetCount();
            if (cnt <= 0 || (fa = this.getFieldAnnotation(field)) == null) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.DLC_DUBIOUS_LIST_COLLECTION.name(), major >= 48 ? 2 : 3).addClass((PreorderVisitor)this).addField(fa).addSourceLine(fi.getSourceLineAnnotation()));
        }
    }

    private FieldAnnotation getFieldAnnotation(String fieldName) {
        Field[] fields;
        JavaClass cls = this.getClassContext().getJavaClass();
        for (Field f : fields = cls.getFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return new FieldAnnotation(cls.getClassName(), fieldName, f.getSignature(), (f.getAccessFlags() & 8) != 0);
        }
        return null;
    }

    class FieldInfo {
        private int setCnt = 0;
        private SourceLineAnnotation slAnnotation = null;

        FieldInfo() {
        }

        public void addUse(int pc) {
            ++this.setCnt;
            if (this.slAnnotation == null) {
                this.slAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)DubiousListCollection.this.getClassContext(), (PreorderVisitor)DubiousListCollection.this, (int)pc);
            }
        }

        public SourceLineAnnotation getSourceLineAnnotation() {
            return this.slAnnotation;
        }

        public int getSetCount() {
            return this.setCnt;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

