/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.LocalHangingExecutor;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class HangingExecutors
extends BytecodeScanningDetector {
    private static final Set<String> hangableSig = UnmodifiableSet.create("Ljava/util/concurrent/ExecutorService;", "Ljava/util/concurrent/AbstractExecutorService;", "Ljava/util/concurrent/ForkJoinPool;", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "Ljava/util/concurrent/ThreadPoolExecutor;");
    private static final Set<String> shutdownMethods = UnmodifiableSet.create("shutdown", "shutdownNow");
    private final BugReporter bugReporter;
    private Map<XField, AnnotationPriority> hangingFieldCandidates;
    private Map<XField, Integer> exemptExecutors;
    private OpcodeStack stack;
    private String methodName;
    private final LocalHangingExecutor localHEDetector;

    public HangingExecutors(BugReporter reporter) {
        this.bugReporter = reporter;
        this.localHEDetector = new LocalHangingExecutor((Detector)this, reporter);
    }

    public void visitClassContext(ClassContext classContext) {
        this.localHEDetector.visitClassContext(classContext);
        try {
            this.hangingFieldCandidates = new HashMap<XField, AnnotationPriority>();
            this.exemptExecutors = new HashMap<XField, Integer>();
            this.parseFieldsForHangingCandidates(classContext);
            if (!this.hangingFieldCandidates.isEmpty()) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
                this.reportHangingExecutorFieldBugs();
            }
        }
        finally {
            this.stack = null;
            this.hangingFieldCandidates = null;
            this.exemptExecutors = null;
        }
    }

    private void parseFieldsForHangingCandidates(ClassContext classContext) {
        Field[] fields;
        JavaClass cls = classContext.getJavaClass();
        for (Field f : fields = cls.getFields()) {
            String sig = f.getSignature();
            if (!hangableSig.contains(sig)) continue;
            this.hangingFieldCandidates.put(XFactory.createXField((String)cls.getClassName(), (String)f.getName(), (String)f.getSignature(), (boolean)f.isStatic()), new AnnotationPriority(FieldAnnotation.fromBCELField((JavaClass)cls, (Field)f), 2));
        }
    }

    private void reportHangingExecutorFieldBugs() {
        for (Map.Entry<XField, AnnotationPriority> entry : this.hangingFieldCandidates.entrySet()) {
            AnnotationPriority fieldAn = entry.getValue();
            if (fieldAn == null) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.HES_EXECUTOR_NEVER_SHUTDOWN.name(), fieldAn.priority).addClass((PreorderVisitor)this).addField(fieldAn.annotation).addField(entry.getKey()));
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.exemptExecutors.clear();
        if (!this.hangingFieldCandidates.isEmpty()) {
            super.visitCode(obj);
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            this.lookForCustomThreadFactoriesInConstructors(seen);
            return;
        }
        try {
            OpcodeStack.Item nullCheckItem;
            XField fieldWhichWasNullChecked;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 182 || seen == 185) {
                OpcodeStack.Item invokeeItem;
                XField fieldOnWhichMethodIsInvoked;
                String sig = this.getSigConstantOperand();
                int argCount = Type.getArgumentTypes((String)sig).length;
                if (this.stack.getStackDepth() > argCount && (fieldOnWhichMethodIsInvoked = (invokeeItem = this.stack.getStackItem(argCount)).getXField()) != null) {
                    this.removeCandidateIfShutdownCalled(fieldOnWhichMethodIsInvoked);
                    this.addExemptionIfShutdownCalled(fieldOnWhichMethodIsInvoked);
                }
            } else if (seen == 176) {
                this.removeFieldsThatGetReturned();
            } else if (seen == 181) {
                XField f = this.getXFieldOperand();
                if (f != null) {
                    this.reportOverwrittenField(f);
                }
            } else if (seen == 199 && (fieldWhichWasNullChecked = (nullCheckItem = this.stack.getStackItem(0)).getXField()) != null) {
                this.exemptExecutors.put(fieldWhichWasNullChecked, this.getPC() + this.getBranchOffset());
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookForCustomThreadFactoriesInConstructors(int seen) {
        try {
            AnnotationPriority ap;
            Type[] argumentTypes;
            XMethod method;
            XField f;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 181 && (f = this.getXFieldOperand()) != null && hangableSig.contains(f.getSignature()) && (method = this.stack.getStackItem(0).getReturnValueOf()) != null && (argumentTypes = Type.getArgumentTypes((String)method.getSignature())).length != 0 && "Ljava/util/concurrent/ThreadFactory;".equals(argumentTypes[argumentTypes.length - 1].getSignature()) && (ap = this.hangingFieldCandidates.get(f)) != null) {
                ap.priority = 3;
                this.hangingFieldCandidates.put(f, ap);
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private void reportOverwrittenField(XField f) {
        if ("Ljava/util/concurrent/ExecutorService;".equals(f.getSignature()) && !this.checkException(f)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.HES_EXECUTOR_OVERWRITTEN_WITHOUT_SHUTDOWN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addField(f).addSourceLine((BytecodeScanningDetector)this));
        }
        this.exemptExecutors.remove(f);
    }

    private boolean checkException(XField f) {
        if (!this.exemptExecutors.containsKey(f)) {
            return false;
        }
        int i = this.exemptExecutors.get(f);
        return i == -1 || this.getPC() < i;
    }

    private void removeFieldsThatGetReturned() {
        OpcodeStack.Item returnItem;
        XField field;
        if (this.stack.getStackDepth() > 0 && (field = (returnItem = this.stack.getStackItem(0)).getXField()) != null) {
            this.hangingFieldCandidates.remove(field);
        }
    }

    private void addExemptionIfShutdownCalled(XField fieldOnWhichMethodIsInvoked) {
        String methodBeingInvoked = this.getNameConstantOperand();
        if (shutdownMethods.contains(methodBeingInvoked)) {
            this.exemptExecutors.put(fieldOnWhichMethodIsInvoked, Values.NEGATIVE_ONE);
        }
    }

    private void removeCandidateIfShutdownCalled(XField fieldOnWhichMethodIsInvoked) {
        String methodBeingInvoked;
        if (this.hangingFieldCandidates.containsKey(fieldOnWhichMethodIsInvoked) && shutdownMethods.contains(methodBeingInvoked = this.getNameConstantOperand())) {
            this.hangingFieldCandidates.remove(fieldOnWhichMethodIsInvoked);
        }
    }

    private static class AnnotationPriority {
        int priority;
        FieldAnnotation annotation;

        AnnotationPriority(FieldAnnotation annotation, int priority) {
            this.annotation = annotation;
            this.priority = priority;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

