/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.MissingMethodsDetector;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import java.util.Set;

public class HttpClientProblems
extends MissingMethodsDetector {
    private static Set<String> httpRequestClasses = UnmodifiableSet.create("org.apache.http.client.methods.HttpGet", "org.apache.http.client.methods.HttpPut", "org.apache.http.client.methods.HttpDelete", "org.apache.http.client.methods.HttpPost", "org.apache.http.client.methods.HttpPatch");
    private static Set<String> resetMethods = UnmodifiableSet.create("reset", "releaseConnection");
    private static Set<String> whiteListMethods = UnmodifiableSet.create("execute", "fatal", "error", "info", "debug", "trace", "println", "print", "format", "append");

    public HttpClientProblems(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected BugInstance makeFieldBugInstance() {
        return new BugInstance((Detector)this, BugType.HCP_HTTP_REQUEST_RESOURCES_NOT_FREED_FIELD.name(), 2);
    }

    @Override
    protected BugInstance makeLocalBugInstance() {
        return new BugInstance((Detector)this, BugType.HCP_HTTP_REQUEST_RESOURCES_NOT_FREED_LOCAL.name(), 2);
    }

    @Override
    protected boolean doesObjectNeedToBeWatched(String type) {
        return httpRequestClasses.contains(type);
    }

    @Override
    protected boolean doesStaticFactoryReturnNeedToBeWatched(String clsName, String methodName, String signature) {
        return false;
    }

    @Override
    protected boolean isMethodThatShouldBeCalled(String methodName) {
        return resetMethods.contains(methodName);
    }

    @Override
    protected void processMethodParms() {
        String nameConstantOperand = this.getNameConstantOperand();
        if (!whiteListMethods.contains(nameConstantOperand)) {
            super.processMethodParms();
        }
    }
}

