/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.FQMethod;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class IOIssues
extends BytecodeScanningDetector {
    private static final String ANY_PARMS = "(*)";
    private static Set<FQMethod> COPY_METHODS = UnmodifiableSet.create(new FQMethod("java.nio.file.Files", "copy", "(*)"), new FQMethod("org.apache.commons.io.IOUtils", "copy", "(*)"), new FQMethod("org.apache.commons.io.IOUtils", "copyLarge", "(*)"), new FQMethod("org.springframework.util.FileCopyUtils", "copy", "(*)"), new FQMethod("org.springframework.util.FileCopyUtils", "copyToByteArray", "(*)"), new FQMethod("com.google.common.io.Files", "copy", "(*)"), new FQMethod("org.apache.poi.openxml4j.opc.StreamHelper", "copyStream", "(*)"));
    private static final Set<String> BUFFERED_CLASSES = UnmodifiableSet.create("java.io.BufferedInputStream", "java.io.BufferedOutputStream", "java.io.BufferedReader", "java.io.BufferedWriter");
    private static JavaClass READER_CLASS;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public IOIssues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext clsContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(clsContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        IOIUserValue uvSawBuffer = null;
        try {
            switch (seen) {
                case 183: {
                    String clsName = this.getDottedClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    if (!"<init>".equals(methodName)) return;
                    if (BUFFERED_CLASSES.contains(clsName)) {
                        uvSawBuffer = IOIUserValue.BUFFER;
                        return;
                    }
                    JavaClass cls = Repository.lookupClass((String)clsName);
                    if (!cls.instanceOf(READER_CLASS)) return;
                    uvSawBuffer = IOIUserValue.READER;
                    return;
                }
                case 184: {
                    String clsName = this.getDottedClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    FQMethod m = new FQMethod(clsName, methodName, ANY_PARMS);
                    if (!COPY_METHODS.contains(m)) return;
                    String signature = this.getSigConstantOperand();
                    Type[] argTypes = Type.getArgumentTypes((String)signature);
                    if (this.stack.getStackDepth() < argTypes.length) return;
                    int i = 0;
                    while (i < argTypes.length) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        IOIUserValue uv = (IOIUserValue)((Object)itm.getUserValue());
                        if (uv != null) {
                            switch (uv) {
                                case BUFFER: {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IOI_DOUBLE_BUFFER_COPY.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                    return;
                                }
                                case READER: {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IOI_COPY_WITH_READER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                    return;
                                }
                            }
                            return;
                        }
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (uvSawBuffer != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)uvSawBuffer);
            }
        }
    }

    static {
        try {
            READER_CLASS = Repository.lookupClass((String)"java.io.Reader");
        }
        catch (ClassNotFoundException cnfe) {
            READER_CLASS = null;
        }
    }

    static enum IOIUserValue {
        BUFFER,
        READER;

    }
}

