/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class ImmatureClass
extends PreorderVisitor
implements Detector {
    private static final Pattern ARG_PATTERN = Pattern.compile("(arg|parm|param)\\d");
    private static final int MAX_EMPTY_METHOD_SIZE = 2;
    private BugReporter bugReporter;

    public ImmatureClass(BugReporter reporter) {
        this.bugReporter = reporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (cls.getPackageName().isEmpty()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IMC_IMMATURE_CLASS_NO_PACKAGE.name(), 3).addClass(cls));
        }
        if (!(cls.isAbstract() || cls.isEnum() || cls.getClassName().contains("$") || ImmatureClass.isTestClass(cls))) {
            try {
                boolean clsHasRuntimeAnnotation = ImmatureClass.classHasRuntimeVisibleAnnotation(cls);
                HEStatus heStatus = HEStatus.UNKNOWN;
                this.checkIDEGeneratedParmNames(cls);
                for (Field f : cls.getFields()) {
                    if (f.isStatic() || f.isSynthetic()) continue;
                    boolean fieldHasRuntimeAnnotation = ImmatureClass.fieldHasRuntimeVisibleAnnotation(f);
                    if (!fieldHasRuntimeAnnotation) {
                        if (!ImmatureClass.hasMethodInHierarchy(cls, "toString", "()Ljava/lang/String;")) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IMC_IMMATURE_CLASS_NO_TOSTRING.name(), 3).addClass(cls));
                            return;
                        }
                        if (heStatus == HEStatus.NOT_NEEDED) continue;
                        String fieldSig = f.getSignature();
                        if (fieldSig.startsWith("L")) {
                            if (!fieldSig.startsWith("Ljava")) {
                                JavaClass fieldClass = Repository.lookupClass((String)fieldSig.substring(1, fieldSig.length() - 1));
                                if (ImmatureClass.hasMethodInHierarchy(fieldClass, "equals", "(Ljava/lang/Object)Z")) continue;
                                heStatus = HEStatus.NOT_NEEDED;
                                continue;
                            }
                            if (fieldSig.startsWith("Ljava/lang/") || fieldSig.startsWith("Ljava/util/")) continue;
                            heStatus = HEStatus.NOT_NEEDED;
                            continue;
                        }
                        if (fieldSig.startsWith("[")) continue;
                        heStatus = HEStatus.NEEDED;
                        continue;
                    }
                    heStatus = HEStatus.NOT_NEEDED;
                }
                if (!clsHasRuntimeAnnotation && heStatus == HEStatus.NEEDED) {
                    if (!ImmatureClass.hasMethodInHierarchy(cls, "equals", "(Ljava/lang/Object;)Z")) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IMC_IMMATURE_CLASS_NO_EQUALS.name(), 3).addClass(cls));
                    } else if (!ImmatureClass.hasMethodInHierarchy(cls, "hashCode", "()I")) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IMC_IMMATURE_CLASS_NO_HASHCODE.name(), 3).addClass(cls));
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    public void report() {
    }

    private static boolean hasMethodInHierarchy(JavaClass cls, String methodName, String methodSig) throws ClassNotFoundException {
        MethodInfo mi = null;
        do {
            String clsName;
            if ("java.lang.Object".equals(clsName = cls.getClassName())) {
                return false;
            }
            mi = Statistics.getStatistics().getMethodStatistics(clsName.replace('.', '/'), methodName, methodSig);
            cls = cls.getSuperClass();
        } while (mi.getNumBytes() == 0);
        return true;
    }

    private static boolean classHasRuntimeVisibleAnnotation(JavaClass cls) {
        AnnotationEntry[] annotations = cls.getAnnotationEntries();
        if (annotations != null) {
            for (AnnotationEntry annotation : annotations) {
                if (!annotation.isRuntimeVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean fieldHasRuntimeVisibleAnnotation(Field f) {
        AnnotationEntry[] annotations = f.getAnnotationEntries();
        if (annotations != null) {
            for (AnnotationEntry annotation : annotations) {
                if (!annotation.isRuntimeVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTestClass(JavaClass cls) {
        for (Method m : cls.getMethods()) {
            for (AnnotationEntry entry : m.getAnnotationEntries()) {
                String type = entry.getAnnotationType();
                if (!type.startsWith("Lorg/junit/") && !type.startsWith("Lorg/testng/")) continue;
                return true;
            }
        }
        return false;
    }

    private void checkIDEGeneratedParmNames(JavaClass cls) {
        block0: for (Method m : cls.getMethods()) {
            int numArgs;
            LocalVariableTable lvt;
            String name;
            if (!m.isPublic() || "<init>".equals(name = m.getName()) || "<clinit>".equals(name) || (lvt = m.getLocalVariableTable()) == null || m.getCode().getCode().length <= 2 || (numArgs = m.getArgumentTypes().length) == 0) continue;
            int offset = m.isStatic() ? 0 : 1;
            for (int i = 0; i < numArgs; ++i) {
                Matcher ma;
                LocalVariable lv = lvt.getLocalVariable(offset + i, 0);
                if (lv == null || lv.getName() == null || !(ma = ARG_PATTERN.matcher(lv.getName())).matches()) continue block0;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IMC_IMMATURE_CLASS_IDE_GENERATED_PARAMETER_NAMES.name(), 2).addClass(cls).addMethod(cls, m));
            return;
        }
    }

    static enum HEStatus {
        NOT_NEEDED,
        UNKNOWN,
        NEEDED;

    }
}

