/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class InconsistentKeyNameCasing
extends BytecodeScanningDetector {
    private static final String HTTP_SESSION = "javax/servlet/http/HttpSession";
    private static final String HTTP_SERVLET_REQUEST = "javax/servlet/http/HttpServletRequest";
    private static final String GET_ATTRIBUTE = "getAttribute";
    private static final String SET_ATTRIBUTE = "setAttribute";
    private static final String GET_PARAMETER = "getParameter";
    private static final String GET_ATTRIBUTE_SIG = "(Ljava/lang/String;)Ljava/lang/Object;";
    private static final String SET_ATTRIBUTE_SIG = "(Ljava/lang/String;Ljava/lang/Object;)V";
    private static final String GET_PARAMETER_SIG = "(Ljava/lang/String;)Ljava/lang/String;";
    BugReporter bugReporter;
    OpcodeStack stack;
    Map<KeyType, Map<String, Map<String, List<SourceInfo>>>> parmInfo;

    public InconsistentKeyNameCasing(BugReporter reporter) {
        this.bugReporter = reporter;
        this.parmInfo = new EnumMap<KeyType, Map<String, Map<String, List<SourceInfo>>>>(KeyType.class);
        this.parmInfo.put(KeyType.ATTRIBUTE, new HashMap());
        this.parmInfo.put(KeyType.PARAMETER, new HashMap());
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            KeyType type;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 185 && (type = this.isKeyAccessMethod(seen)) != null) {
                OpcodeStack.Item item;
                String parmName;
                int numParms = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                if (this.stack.getStackDepth() >= numParms && (parmName = (String)(item = this.stack.getStackItem(numParms - 1)).getConstant()) != null) {
                    List<SourceInfo> annotations;
                    String upperParmName = parmName.toUpperCase(Locale.getDefault());
                    Map<String, Map<String, List<SourceInfo>>> typeMap = this.parmInfo.get((Object)KeyType.PARAMETER);
                    Map<String, List<SourceInfo>> parmCaseInfo = typeMap.get(upperParmName);
                    if (parmCaseInfo == null) {
                        parmCaseInfo = new HashMap<String, List<SourceInfo>>();
                        typeMap.put(upperParmName, parmCaseInfo);
                    }
                    if ((annotations = parmCaseInfo.get(parmName)) == null) {
                        annotations = new ArrayList<SourceInfo>();
                        parmCaseInfo.put(parmName, annotations);
                    }
                    annotations.add(new SourceInfo(this.getClassName(), this.getMethodName(), this.getMethodSig(), this.getMethod().isStatic(), SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.getClassContext(), (PreorderVisitor)this, (int)this.getPC())));
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    public void report() {
        for (Map.Entry<KeyType, Map<String, Map<String, List<SourceInfo>>>> entry : this.parmInfo.entrySet()) {
            KeyType type = entry.getKey();
            Map<String, Map<String, List<SourceInfo>>> typeMap = entry.getValue();
            for (Map<String, List<SourceInfo>> parmCaseInfo : typeMap.values()) {
                if (parmCaseInfo.size() <= 1) continue;
                BugInstance bi = new BugInstance((Detector)this, type.getDescription(), 2);
                for (Map.Entry<String, List<SourceInfo>> sourceInfos : parmCaseInfo.entrySet()) {
                    for (SourceInfo sourceInfo : sourceInfos.getValue()) {
                        bi.addClass(sourceInfo.clsName);
                        bi.addMethod(sourceInfo.clsName, sourceInfo.methodName, sourceInfo.signature, sourceInfo.isStatic);
                        bi.addSourceLine(sourceInfo.srcLine);
                        bi.addString(sourceInfos.getKey());
                    }
                }
                this.bugReporter.reportBug(bi);
            }
        }
        this.parmInfo.clear();
    }

    private KeyType isKeyAccessMethod(int seen) {
        if (seen == 185) {
            String methodName;
            String clsName = this.getClassConstantOperand();
            if (HTTP_SESSION.equals(clsName)) {
                String methodName2 = this.getNameConstantOperand();
                if (GET_ATTRIBUTE.equals(methodName2)) {
                    String signature = this.getSigConstantOperand();
                    return GET_ATTRIBUTE_SIG.equals(signature) ? KeyType.ATTRIBUTE : null;
                }
                if (SET_ATTRIBUTE.equals(methodName2)) {
                    String signature = this.getSigConstantOperand();
                    return SET_ATTRIBUTE_SIG.equals(signature) ? KeyType.ATTRIBUTE : null;
                }
            } else if (HTTP_SERVLET_REQUEST.equals(clsName) && GET_PARAMETER.equals(methodName = this.getNameConstantOperand())) {
                String signature = this.getSigConstantOperand();
                return GET_PARAMETER_SIG.equals(signature) ? KeyType.PARAMETER : null;
            }
        }
        return null;
    }

    static class SourceInfo {
        String clsName;
        String methodName;
        String signature;
        boolean isStatic;
        SourceLineAnnotation srcLine;

        SourceInfo(String cls, String method, String sig, boolean mStatic, SourceLineAnnotation annotation) {
            this.clsName = cls;
            this.methodName = method;
            this.signature = sig;
            this.isStatic = mStatic;
            this.srcLine = annotation;
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static enum KeyType {
        ATTRIBUTE("IKNC_INCONSISTENT_HTTP_ATTRIBUTE_CASING"),
        PARAMETER("IKNC_INCONSISTENT_HTTP_PARAM_CASING");

        private String key;

        private KeyType(String descriptionKey) {
            this.key = descriptionKey;
        }

        public String getDescription() {
            return this.key;
        }
    }
}

