/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;

public class IncorrectInternalClassUse
implements Detector {
    private final BugReporter bugReporter;
    private static final Set<String> internalPackages = UnmodifiableSet.create("sun/", "org/apache/commons/digester/annotations/internal", "org/apache/xerces/", "org/apache/xalan/", "org/mockito/internal/", "org/springframework/asm/", "org/springframework/cglib/", "org/springframework/objenesis/");
    private static final Set<String> externalPackages = UnmodifiableSet.create("org/apache/xerces/xni/", "org/apache/xerces/xs/", "org/apache/xalan/extensions");

    public IncorrectInternalClassUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext context) {
        JavaClass cls = context.getJavaClass();
        if (!IncorrectInternalClassUse.isInternal(cls.getClassName())) {
            ConstantPool pool = cls.getConstantPool();
            int numItems = pool.getLength();
            for (int i = 0; i < numItems; ++i) {
                String clsName;
                Constant c = pool.getConstant(i);
                if (!(c instanceof ConstantClass) || !IncorrectInternalClassUse.isInternal(clsName = ((ConstantClass)c).getBytes(pool))) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.IICU_INCORRECT_INTERNAL_CLASS_USE.name(), 2).addClass(cls).addString(clsName));
            }
        }
    }

    public void report() {
    }

    private static boolean isInternal(String clsName) {
        boolean internal = false;
        for (String internalPackage : internalPackages) {
            if (!clsName.startsWith(internalPackage)) continue;
            internal = true;
            break;
        }
        if (internal) {
            for (String externalPackage : externalPackages) {
                if (!clsName.startsWith(externalPackage)) continue;
                internal = false;
                break;
            }
        }
        return internal;
    }

    public String toString() {
        return ToString.build(this);
    }
}

