/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;

@OpcodeStack.CustomUserValue
public class InefficientStringBuffering
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private boolean sawLDCEmpty;

    public InefficientStringBuffering(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (obj.getCode() != null) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.sawLDCEmpty = false;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        ISBUserValue userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 183) {
                userValue = this.sawInvokeSpecial(userValue);
            } else if (seen == 182) {
                if (this.sawLDCEmpty) {
                    this.dealWithEmptyString();
                }
                userValue = this.sawInvokeVirtual(userValue);
            } else if (seen == 167 || seen == 200) {
                int depth = this.stack.getStackDepth();
                for (int i = 0; i < depth; ++i) {
                    OpcodeStack.Item itm = this.stack.getStackItem(i);
                    itm.setUserValue(null);
                }
            } else if (seen == 18 || seen == 19) {
                String s;
                Constant c = this.getConstantRefOperand();
                if (c instanceof ConstantString && (s = ((ConstantString)c).getBytes(this.getConstantPool())).length() == 0) {
                    this.sawLDCEmpty = true;
                }
            } else if (OpcodeUtils.isALoad(seen)) {
                userValue = new ISBUserValue(AppendType.CLEAR, true);
            }
        }
        finally {
            this.handleOpcode(seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)userValue);
            }
        }
    }

    private void handleOpcode(int seen) {
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
    }

    private ISBUserValue sawInvokeVirtual(ISBUserValue userValue) {
        String calledClass = this.getClassConstantOperand();
        if ("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) {
            String methodName = this.getNameConstantOperand();
            if ("append".equals(methodName)) {
                ISBUserValue uv;
                OpcodeStack.Item itm = this.getStringBufferItemAt(1);
                if (itm != null) {
                    userValue = (ISBUserValue)itm.getUserValue();
                }
                if (this.stack.getStackDepth() > 0 && (uv = (ISBUserValue)(itm = this.stack.getStackItem(0)).getUserValue()) != null) {
                    switch (uv.getAppendType()) {
                        case NESTED: {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_INEFFICIENT_STRING_BUFFERING.name(), "toString".equals(this.getMethodName()) ? 3 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case TOSTRING: {
                            if (this.stack.getStackDepth() <= 1 || (itm = this.stack.getStackItem(1)) == null || (uv = (ISBUserValue)itm.getUserValue()) == null || !uv.hasResolvedString()) break;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_TOSTRING_APPENDING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                    }
                }
                if (this.getSigConstantOperand().startsWith("(Ljava/lang/String;)")) {
                    userValue = userValue == null ? new ISBUserValue(AppendType.CLEAR, true) : new ISBUserValue(userValue.getAppendType(), true);
                }
            } else if ("toString".equals(methodName)) {
                OpcodeStack.Item itm = this.getStringBufferItemAt(0);
                userValue = (ISBUserValue)itm.getUserValue();
            }
        } else if ("toString".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getRegisterNumber() != 0) {
            userValue = new ISBUserValue(AppendType.TOSTRING);
        }
        return userValue;
    }

    private void dealWithEmptyString() {
        OpcodeStack.Item itm;
        Object cons;
        OpcodeStack.Item sbItm;
        String calledClass = this.getClassConstantOperand();
        if (("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) && "append".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)") && this.stack.getStackDepth() > 1 && (sbItm = this.stack.getStackItem(1)) != null && sbItm.getUserValue() == null && (cons = (itm = this.stack.getStackItem(0)).getConstant()) instanceof String && itm.getRegisterNumber() < 0 && ((String)cons).length() == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_EMPTY_STRING_APPENDING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private ISBUserValue sawInvokeSpecial(ISBUserValue userValue) {
        String calledClass = this.getClassConstantOperand();
        if (("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) && "<init>".equals(this.getNameConstantOperand())) {
            String signature = this.getSigConstantOperand();
            if ("()V".equals(signature)) {
                OpcodeStack.Item itm = this.getStringBufferItemAt(2);
                if (itm != null) {
                    userValue = new ISBUserValue(AppendType.NESTED);
                }
            } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                userValue = (ISBUserValue)itm.getUserValue();
                if (userValue != null && userValue.getAppendType() == AppendType.NESTED) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_INEFFICIENT_STRING_BUFFERING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if (userValue == null) {
                    userValue = new ISBUserValue(AppendType.CLEAR, true);
                }
            }
        }
        return userValue;
    }

    private OpcodeStack.Item getStringBufferItemAt(int depth) {
        OpcodeStack.Item itm;
        String signature;
        if (this.stack.getStackDepth() > depth && ("Ljava/lang/StringBuffer;".equals(signature = (itm = this.stack.getStackItem(depth)).getSignature()) || "Ljava/lang/StringBuilder;".equals(signature))) {
            return itm;
        }
        return null;
    }

    static class ISBUserValue {
        private AppendType appendType;
        private boolean hasResolvedString;

        public ISBUserValue(AppendType appType) {
            this(appType, false);
        }

        public ISBUserValue(AppendType appType, boolean resolved) {
            this.appendType = appType;
            this.hasResolvedString = resolved;
        }

        public AppendType getAppendType() {
            return this.appendType;
        }

        public boolean hasResolvedString() {
            return this.hasResolvedString;
        }

        public int hashCode() {
            return this.appendType.hashCode() ^ (this.hasResolvedString ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ISBUserValue)) {
                return false;
            }
            ISBUserValue that = (ISBUserValue)obj;
            return this.appendType == that.appendType && this.hasResolvedString == that.hasResolvedString;
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    private static enum AppendType {
        CLEAR,
        NESTED,
        TOSTRING;

    }
}

