/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class InvalidConstantArgument
extends BytecodeScanningDetector {
    private static final Map<Pattern, List<ParameterInfo<?>>> PATTERNS;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    private static void addPattern(Map<Pattern, List<ParameterInfo<?>>> patterns, String pattern, ParameterInfo<?> ... info) {
        patterns.put(Pattern.compile(pattern), Arrays.asList(info));
    }

    public InvalidConstantArgument(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitMethod(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    OpcodeStack.Item item;
                    Comparable cons;
                    ParameterInfo<?> info;
                    int parmOffset;
                    Map.Entry<Pattern, List<ParameterInfo<?>>> entry;
                    Matcher m;
                    String sig = this.getSigConstantOperand();
                    String mInfo = this.getClassConstantOperand() + '#' + this.getNameConstantOperand() + sig;
                    Iterator<Map.Entry<Pattern, List<ParameterInfo<?>>>> iterator = PATTERNS.entrySet().iterator();
                    do {
                        if (!iterator.hasNext()) return;
                    } while (!(m = (entry = iterator.next()).getKey().matcher(mInfo)).matches());
                    Iterator<ParameterInfo<?>> iterator2 = entry.getValue().iterator();
                    do {
                        if (!iterator2.hasNext()) return;
                        info = iterator2.next();
                        int n = parmOffset = ((ParameterInfo)info).fromStart ? Type.getArgumentTypes((String)sig).length - ((ParameterInfo)info).parameterOffset - 1 : ((ParameterInfo)info).parameterOffset;
                    } while (this.stack.getStackDepth() <= parmOffset || info.isValid(cons = (Comparable)(item = this.stack.getStackItem(parmOffset)).getConstant()));
                    int badParm = 1 + (((ParameterInfo)info).fromStart ? ((ParameterInfo)info).parameterOffset : Type.getArgumentTypes((String)sig).length - ((ParameterInfo)info).parameterOffset - 1);
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ICA_INVALID_CONSTANT_ARGUMENT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("Parameter " + badParm));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    static {
        HashMap patterns = new HashMap(10);
        InvalidConstantArgument.addPattern(patterns, "javax/swing/JOptionPane#showMessageDialog\\(Ljava/awt/Component;Ljava/lang/Object;Ljava/lang/String;I\\)V", ParameterInfo.createIntegerParameterInfo(0, false, 0, 1, -1, 2));
        InvalidConstantArgument.addPattern(patterns, "javax/swing/BorderFactory#createBevelBorder\\(I.*\\)Ljavax/swing/border/Border;", ParameterInfo.createIntegerParameterInfo(0, true, 1, 0));
        InvalidConstantArgument.addPattern(patterns, "javax/swing/BorderFactory#createEtchedBorder\\(I.*\\)Ljavax/swing/border/Border;", ParameterInfo.createIntegerParameterInfo(0, true, 1, 0));
        InvalidConstantArgument.addPattern(patterns, "javax/swing/JScrollBar#\\<init\\>\\(I.*\\)V", ParameterInfo.createIntegerParameterInfo(0, true, 0, 1));
        InvalidConstantArgument.addPattern(patterns, "java/lang/Thread#setPriority\\(I\\)V", new ParameterInfo<Integer>(0, true, Range.createIntegerRange(1, 10)));
        InvalidConstantArgument.addPattern(patterns, "java/math/BigDecimal#divide\\(Ljava/math/BigDecimal;.*I\\)Ljava/math/BigDecimal;", new ParameterInfo<Integer>(0, false, Range.createIntegerRange(0, 7)));
        InvalidConstantArgument.addPattern(patterns, "java/math/BigDecimal#setScale\\(II\\)Ljava/math/BigDecimal;", new ParameterInfo<Integer>(0, false, Range.createIntegerRange(0, 7)));
        InvalidConstantArgument.addPattern(patterns, "java/sql/Connection#createStatement\\(II\\)Ljava/sql/Statement;", ParameterInfo.createIntegerParameterInfo(0, true, 1003, 1004, 1005));
        InvalidConstantArgument.addPattern(patterns, "java/sql/Connection#createStatement\\(III?\\)Ljava/sql/Statement;", ParameterInfo.createIntegerParameterInfo(0, true, 1003, 1004, 1005), ParameterInfo.createIntegerParameterInfo(1, true, 1007, 1008));
        InvalidConstantArgument.addPattern(patterns, "java/sql/Connection#prepare[^\\(]+\\(Ljava/lang/String;III?\\)Ljava/sql/PreparedStatement;", ParameterInfo.createIntegerParameterInfo(1, true, 1003, 1004, 1005), ParameterInfo.createIntegerParameterInfo(2, true, 1007, 1008));
        PATTERNS = Collections.unmodifiableMap(patterns);
    }

    static class Range<T extends Comparable<T>> {
        T from;
        T to;

        public Range(T f, T t) {
            this.from = f;
            this.to = t;
        }

        public static Range<Integer> createIntegerRange(int f, int t) {
            return new Range<Integer>(f, t);
        }

        public T getFrom() {
            return this.from;
        }

        public T getTo() {
            return this.to;
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    static class ParameterInfo<T extends Comparable<T>> {
        private int parameterOffset;
        private boolean fromStart;
        private Set<T> validValues;
        private Range<T> range;

        public ParameterInfo(int offset, boolean start, T ... values) {
            this.parameterOffset = offset;
            this.fromStart = start;
            this.validValues = new HashSet<T>(Arrays.asList(values));
            this.range = null;
        }

        public ParameterInfo(int offset, boolean start, Range<T> rng) {
            this.parameterOffset = offset;
            this.fromStart = start;
            this.validValues = null;
            this.range = rng;
        }

        public static ParameterInfo<Integer> createIntegerParameterInfo(int offset, boolean start, int ... values) {
            ParameterInfo info = new ParameterInfo(offset, start, (Comparable[])new Integer[0]);
            for (int v : values) {
                info.validValues.add(v);
            }
            return info;
        }

        public boolean isValid(Comparable<T> o) {
            if (o == null) {
                return true;
            }
            if (this.validValues != null) {
                return this.validValues.contains(o);
            }
            return o.compareTo(this.range.getFrom()) >= 0 && o.compareTo(this.range.getTo()) <= 0;
        }
    }
}

