/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.UnmodifiableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;

public class JAXRSIssues
extends PreorderVisitor
implements Detector {
    private static final Set<String> METHOD_ANNOTATIONS = UnmodifiableSet.create("Ljavax/ws/rs/HEAD;", "Ljavax/ws/rs/GET;", "Ljavax/ws/rs/PUT;", "Ljavax/ws/rs/POST;", "Ljavax/ws/rs/DELETE;", "Ljavax/ws/rs/POST;");
    private static final Set<String> PARAM_ANNOTATIONS = UnmodifiableSet.create("Ljavax/ws/rs/PathParam;", "Ljavax/ws/rs/CookieParam;", "Ljavax/ws/rs/FormParam;", "Ljavax/ws/rs/HeaderParam;", "Ljavax/ws/rs/MatrixParam;", "Ljavax/ws/rs/QueryParam;", "Ljavax/ws/rs/core/Context;", "Lcom/wordnik/swagger/annotations/ApiParam;");
    private static final Set<String> NATIVE_JAXRS_TYPES = UnmodifiableSet.create("Ljava/lang/String;", "[B", "Ljava/io/InputStream;", "Ljava/io/Reader;", "Ljava/io/File;", "Ljavax/activation/DataSource;", "Ljavax/xml/transform/Source;", "Ljavax/xml/bin/JAXBElement;", "Ljavax/ws/rc/core/MultivaluedMap;");
    private static final Set<String> VALID_CONTEXT_TYPES = UnmodifiableSet.create("Ljavax/ws/rs/core/Application;", "Ljavax/ws/rs/core/UriInfo;", "Ljavax/ws/rs/core/HttpHeaders;", "Ljavax/ws/rs/core/Request;", "Ljavax/ws/rs/core/SecurityContext;", "Ljavax/ws/rs/ext/Providers;", "Ljavax/servlet/ServletConfig;", "Ljavax/servlet/ServletContext;", "Ljavax/servlet/http/HttpServletRequest;", "Ljavax/servlet/http/HttpServletResponse;");
    private BugReporter bugReporter;
    private boolean hasClassConsumes;
    private String pathOnClass;

    public JAXRSIssues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        this.pathOnClass = "";
        this.hasClassConsumes = false;
        for (AnnotationEntry entry : cls.getAnnotationEntries()) {
            if ("Ljavax/ws/rs/Consumes;".equals(entry.getAnnotationType())) {
                this.hasClassConsumes = true;
                continue;
            }
            if (!"Ljavax/ws/rs/Path;".equals(entry.getAnnotationType())) continue;
            this.pathOnClass = this.getDefaultAnnotationValue(entry);
        }
        cls.accept((Visitor)this);
    }

    public void visitMethod(Method obj) {
        if (obj.isSynthetic()) {
            return;
        }
        String path = null;
        boolean isJAXRS = false;
        boolean hasGet = false;
        boolean hasConsumes = false;
        for (AnnotationEntry entry : obj.getAnnotationEntries()) {
            String annotationType;
            switch (annotationType = entry.getAnnotationType()) {
                case "Ljavax/ws/rs/GET;": {
                    hasGet = true;
                    isJAXRS = true;
                    break;
                }
                case "Ljavax/ws/rs/Consumes;": {
                    hasConsumes = true;
                    break;
                }
                case "Ljavax/ws/rs/Path;": {
                    path = this.getDefaultAnnotationValue(entry);
                    break;
                }
                default: {
                    if (!METHOD_ANNOTATIONS.contains(annotationType)) break;
                    isJAXRS = true;
                }
            }
            if (!hasGet || !hasConsumes) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JXI_GET_ENDPOINT_CONSUMES_CONTENT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
            break;
        }
        if (isJAXRS) {
            this.processJAXRSMethod(obj, this.pathOnClass + path, hasConsumes || this.hasClassConsumes);
        }
    }

    private void processJAXRSMethod(Method m, String path, boolean hasConsumes) {
        Type[] parmTypes = m.getArgumentTypes();
        int numParms = parmTypes.length;
        if (numParms > 0) {
            boolean sawBareParm = false;
            ParameterAnnotationEntry[] pes = m.getParameterAnnotationEntries();
            int parmIndex = 0;
            for (ParameterAnnotationEntry pe : pes) {
                boolean foundParamAnnotation = false;
                for (AnnotationEntry a : pe.getAnnotationEntries()) {
                    String parmSig;
                    String annotationType = a.getAnnotationType();
                    if (!PARAM_ANNOTATIONS.contains(annotationType)) continue;
                    foundParamAnnotation = true;
                    if (path != null && "Ljavax/ws/rs/PathParam;".equals(annotationType)) {
                        String parmPath = this.getDefaultAnnotationValue(a);
                        if (parmPath == null || path.matches(".*\\{" + parmPath + "\\b.*")) continue;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JXI_PARM_PARAM_NOT_FOUND_IN_PATH.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString(parmPath));
                        continue;
                    }
                    if (!"Ljavax/ws/rs/core/Context;".equals(annotationType) || VALID_CONTEXT_TYPES.contains(parmSig = parmTypes[parmIndex].getSignature())) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JXI_INVALID_CONTEXT_PARAMETER_TYPE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString(parmSig));
                }
                if (!foundParamAnnotation) {
                    if (!sawBareParm && (hasConsumes || NATIVE_JAXRS_TYPES.contains(parmTypes[parmIndex].getSignature()))) {
                        sawBareParm = true;
                    } else {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JXI_UNDEFINED_PARAMETER_SOURCE_IN_ENDPOINT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString("Parameter " + parmIndex + 1));
                        break;
                    }
                }
                ++parmIndex;
            }
        }
    }

    private String getDefaultAnnotationValue(AnnotationEntry entry) {
        int numPairs = entry.getNumElementValuePairs();
        if (numPairs > 0) {
            ElementValuePair[] pairs;
            for (ElementValuePair pair : pairs = entry.getElementValuePairs()) {
                if (!"value".equals(pair.getNameString())) continue;
                return pair.getValue().stringifyValue();
            }
        }
        return null;
    }

    public void report() {
    }
}

